import gtk, hildon, storage, calculator

class create_window:
    def __init__(self, template=None):
        self.window = hildon.StackableWindow()
        self.window.set_title('New weight log entry')

        menu = hildon.AppMenu()
        self.backdate_button = hildon.DateButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        #import time
        # For some reason I can't fogure out how to set the range
        #self.backdate_button = hildon.HildonDateButton.new_with_year_range(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, int(time.strftime('%Y'))-1, int(time.strftime('%Y')))
        self.backdated =  False
        self.backdate_button.set_label('Backdate')
        self.backdate_button.connect('value-changed', self.backdate_changed)
        menu.append(self.backdate_button)

        menu.show_all()
        self.window.set_app_menu(menu)

        # Divide to two halves
        hbox = gtk.HBox(homogeneous=True)
        self.left_column = gtk.VBox()
        hbox.add(self.left_column)
        self.right_column = gtk.VBox()
        hbox.add(self.right_column)
        self.window.add(hbox)
        
        notes_label = gtk.Label('Notes')
        notes_label.set_alignment(xalign=0, yalign=0)
        self.left_column.pack_start(notes_label, False, False)
        self.notes = hildon.TextView()
        self.left_column.pack_start(self.notes, True, True)


        weight_container = gtk.HBox(homogeneous=True)
        weight_label = gtk.Label('Weight:')
        weight_label.set_alignment(xalign=1, yalign=0.5)
        weight_container.pack_start(weight_label)
        self.weight = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        # TODO: How to use numeric with dots (to input floats)
        self.weight.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        weight_container.pack_start(self.weight)
        self.right_column.pack_start(weight_container)

        self.savebutton = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, 'Save')
        self.savebutton.connect('clicked', self.save)
        self.right_column.pack_start(self.savebutton)

    def backdate_changed(self, *args):
        self.backdated = True

    def save(self, *args):
        hildon.hildon_gtk_window_set_progress_indicator(self.window, 1)
        while gtk.events_pending():
            gtk.main_iteration()
        import time
        entry = storage.midgard.mgdschema.org_maemo_garage_maecalories_weightlog()
        entry.weight = float(self.weight.get_text())
        notesbuffer = self.notes.get_buffer()
        entry.notes = notesbuffer.get_text(notesbuffer.get_start_iter(), notesbuffer.get_end_iter()).strip()
        # TODO: Allow backdating somehow (toolbar button or something)
        entry.person = storage.instance.person.id

        if self.backdated:
            import datetime
            date_tuple = self.backdate_button.get_date()
            entry.time = datetime.datetime(date_tuple[0], date_tuple[1]+1, date_tuple[2], 12, 0, 0)
        else:
            entry.time = storage.utcstamp()

        try:
            entry.create()
        except:
            hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)
            note = hildon.Note('information', window, "Failed to create log entry, error: %s" . storage.midgard._connection.get_error_string())
            gtk.Dialog.run(note)
        print "Saved weight log entry #%d with datetime %s" % (entry.id, repr(entry.time))
        storage.instance.update_caches()
        hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)
        while gtk.events_pending():
            gtk.main_iteration()
        self.window.destroy()

    def run(self):
        self.window.show_all()

class list_window:
    def __init__(self):
        self.window = hildon.StackableWindow()
        self.window.set_title('Weight log')
        # Have a box just in case
        self.main_box = gtk.HBox()
        self.window.add(self.main_box)
        self.render_empty_pannable(self.main_box)

    def run(self):
        self.window.show_all()
        self.load_data()

    def render_empty_pannable(self, container):
        import gobject
        self.liststore = gtk.ListStore(
            gobject.TYPE_STRING, # date as string ?
            gobject.TYPE_STRING, #weight (as string)
            gobject.TYPE_STRING, # notes (first line)
        )

        # TODO: Make a plot instead of list, for example http://matplotlib.sourceforge.net/
        self.treeview = gtk.TreeView(self.liststore)

        datecolumn = gtk.TreeViewColumn()
        datecolumn.set_title('Datetime')
        self.treeview.append_column(datecolumn)
        pointscolumn = gtk.TreeViewColumn()
        pointscolumn.set_title('Points')
        self.treeview.append_column(pointscolumn)
        notescolumn = gtk.TreeViewColumn()
        notescolumn.set_title('Notes')
        self.treeview.append_column(notescolumn)

        daterenderer = gtk.CellRendererText()
        datecolumn.pack_start(daterenderer)
        datecolumn.add_attribute(daterenderer, 'text', 0)
        pointsrenderer = gtk.CellRendererText()
        pointscolumn.pack_start(pointsrenderer)
        pointscolumn.add_attribute(pointsrenderer, 'text', 1)
        notesrenderer = gtk.CellRendererText()
        notescolumn.pack_start(notesrenderer)
        notescolumn.add_attribute(notesrenderer, 'text', 2)

        pannable_area = hildon.PannableArea()
        pannable_area.add(self.treeview)
        pannable_area.show_all()
        container.pack_start(pannable_area)

    def load_data(self):
        # This might take a while, set indicator
        hildon.hildon_gtk_window_set_progress_indicator(self.window, 1)
        while gtk.events_pending():
            gtk.main_iteration()

        # Put our data to the liststore
        # TODO: How to make "infinite scroll" where we limit initial resultset and load more data as we scroll down ?
        qb = storage.midgard.query_builder('org_maemo_garage_maecalories_weightlog')
        qb.add_order('time', 'DESC');
        # Before the infinite scroll is done limit to somewhat sane amount of items
        qb.set_limit(100)
        items = qb.execute()
        for item in items:
            try:
                first_line = item.notes.splitlines()[0]
            except IndexError:
                first_line = '<empty>'
            self.liststore.append((
                item.time.strftime('%Y-%m-%d %H:%M Z'),
                "%.1f" % item.weight,
                first_line
            ))
            # Render as we go
            while gtk.events_pending():
                gtk.main_iteration()
        
        # Done, clear the indicator
        hildon.hildon_gtk_window_set_progress_indicator(self.window, 0)
        while gtk.events_pending():
            gtk.main_iteration()

