import gtk, hildon, storage

class calculator:
    def __init__(self):
        self.gc = storage.instance.gc
        self.set_mode()
        self.gc.notify_add('/apps/maecalories/settings/calculator_mode', self.set_mode)

    def set_mode(self, *args):
        #print "set mode called, args %s" % repr(args)
        self.mode = self.gc.get_string('/apps/maecalories/settings/calculator_mode')
        if self.mode == None:
            self.mode = 'ww_usa_fiber'

    def ww_fiber_algo(self, calories, fat, fiber):
        """Points algo from http://www.ehow.com/how_2058466_calculate-weight-watchers-points.html"""
        x = (float(calories) / 50) + (float(fat) / 12)
        y = float(fiber) / 5
        points = round(x - y)
        return points

    def render_calculator(self, callback=None):
        container = gtk.VBox()
        button_and_value = gtk.HBox(homogeneous=True)
        button = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, 'Calculate')
        button_and_value.pack_start(button)
        self.value_entry = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.value_entry.set_sensitive(False)
        button_and_value.pack_end(self.value_entry)
        container.pack_end(button_and_value)
        self.render_inputs(container, button, self.render_calculator_set_value)
        container.show_all()
        return container

    def render_calculator_set_value(self, points):
        self.value_entry.set_text(str(points))
        self.value_entry.set_sensitive(True)

    def render_inputs(self, container, button, callback=None):
        #print "render_inputs, mode=%s" % self.mode
        if self.mode == 'ww_usa_fiber':
            return self.render_wwfiber_inputs(container, button, callback)
        elif self.mode == 'ww_europe_basic':
            return self.render_wwbasic_inputs(container, button, callback)
        else:
            # Broken mode, if it's in config unset the key before raising the exception
            if self.mode == self.gc.get_string('/apps/maecalories/settings/calculator_mode'):
                self.gc.unset('/apps/maecalories/settings/calculator_mode')
            raise Exception("Unknown mode %s" % self.mode)

    def render_wwfiber_inputs(self, container, button, callback):
        button.connect('clicked', self.wwfiber_button_clicked, callback)
        
        calories_container = gtk.HBox(homogeneous=True)
        calories_label = gtk.Label('kCal:')
        calories_label.set_alignment(xalign=1, yalign=0.5)
        calories_container.pack_start(calories_label)
        self.calories = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.calories.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        calories_container.pack_start(self.calories)
        #self.calories.set_placeholder('Calories')
        container.pack_start(calories_container)

        fat_container = gtk.HBox(homogeneous=True)
        fat_label = gtk.Label('Fat (g):')
        fat_label.set_alignment(xalign=1, yalign=0.5)
        fat_container.pack_start(fat_label)
        self.fat = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.fat.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        fat_container.pack_start(self.fat)
        #self.fat.set_placeholder('Fat')
        container.pack_start(fat_container)

        fiber_container = gtk.HBox(homogeneous=True)
        fiber_label = gtk.Label('Fiber (g):')
        fiber_label.set_alignment(xalign=1, yalign=0.5)
        fiber_container.pack_start(fiber_label)
        self.fiber = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.fiber.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        fiber_container.pack_start(self.fiber)
        #self.fiber.set_placeholder('Fiber')
        container.pack_start(fiber_container)

    def wwfiber_button_clicked(self, button, callback, *args):
        points = self.ww_fiber_algo(
                calories=self.calories.get_text(),
                fat=self.fat.get_text(),
                fiber=self.fiber.get_text()
        )
        callback(points=points)

    def render_wwbasic_inputs(self, container, button, callback):
        button.connect('clicked', self.wwbasic_button_clicked, callback)
        
        calories_container = gtk.HBox(homogeneous=True)
        calories_label = gtk.Label('kCal:')
        calories_label.set_alignment(xalign=1, yalign=0.5)
        calories_container.pack_start(calories_label)
        self.calories = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.calories.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        calories_container.pack_start(self.calories)
        #self.calories.set_placeholder('Calories')
        container.pack_start(calories_container)

        fat_container = gtk.HBox(homogeneous=True)
        fat_label = gtk.Label('Fat (g):')
        fat_label.set_alignment(xalign=1, yalign=0.5)
        fat_container.pack_start(fat_label)
        self.fat = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        self.fat.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        fat_container.pack_start(self.fat)
        #self.fat.set_placeholder('Fat')
        container.pack_start(fat_container)


    def wwbasic_button_clicked(self, button, callback, *args):
        points = self.ww_basic_algo(
                calories=self.calories.get_text(),
                fat=self.fat.get_text(),
        )
        callback(points=points)

    def ww_basic_algo(self, calories, fat):
        """Points algo from http://talk.maemo.org/showpost.php?p=586455&postcount=42"""
        import math
        points = (float(calories) / 60) + (float(fat) / 10)
        # Funky round to "nearest" 0.5
        remainder = points - math.floor(points)
        if (    remainder > 0.3
            and remainder < 0.7):
            points = math.floor(points) + 0.5
        else:
            points = round(points)
        return points


instance = calculator()