#!/usr/bin/run-standalone.sh python2.5

import gtk, hildon, storage
#import gobject, threading
#gtk.gdk.threads_init()

class mainwindow:
    def __init__(self):
        self.gc = storage.instance.gc
        # Initialize the main window
        self.program = hildon.Program.get_instance()
        self.mainwindow = hildon.StackableWindow()
        self.program.add_window(self.mainwindow)
        self.mainwindow.connect('delete_event', self.quit, None)
        self.mainwindow.set_title('maeCalories')

        self.create_menu()
        self.create_base_layout()

    def create_menu(self):
        menu = hildon.AppMenu()
        settings_button = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        settings_button.set_label('Settings')
        settings_button.connect('clicked', self.render_settings)
        menu.append(settings_button)

        # Ponder: move this to the main window ?
        pointslog_button = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        pointslog_button.set_label('Points log')
        pointslog_button.connect('clicked', self.render_pointslog)
        menu.append(pointslog_button)

        weightlog_button = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        weightlog_button.set_label('Weight log')
        weightlog_button.connect('clicked', self.render_weightlog)
        menu.append(weightlog_button)

        menu.show_all()
        self.mainwindow.set_app_menu(menu)

    def render_weightlog(self, *args):
        import weightlog
        wrapper = weightlog.list_window()
        wrapper.run()

    def render_pointslog(self, *args):
        import pointslog
        wrapper = pointslog.list_window()
        wrapper.run()

    def render_settings(self, *args):
        import settings
        wrapper = settings.settings()
        wrapper.run()

    def create_base_layout(self):        
        # Divive window to left and right halves which are vboxes        
        hbox = gtk.HBox(homogeneous=True)
        self.main_left_column = gtk.VBox()
        hbox.add(self.main_left_column)
        self.main_right_column = gtk.VBox()
        hbox.add(self.main_right_column)
        self.mainwindow.add(hbox)

        import calculator
        self.main_right_column.pack_start(self.create_points_labels())
        self.main_right_column.pack_start(calculator.instance.render_calculator())
        
        self.logpoints =  hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, 'Log points')
        self.logpoints.connect('clicked', self.render_add_points)
        self.main_left_column.pack_start(self.logpoints)

        self.logpoints_t =  hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, "Log points\nfrom template")
        #self.logpoints_t.set_justify(gtk.JUSTIFY_CENTER)
        self.logpoints_t.connect('clicked', self.render_add_points_t)
        self.main_left_column.pack_start(self.logpoints_t)

        self.logweight =  hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, 'Log weight')
        self.logweight.connect('clicked', self.render_add_weight)
        self.main_left_column.pack_start(self.logweight)

    def update_dpoints_vl(self, *args, **kwargs):
        #print "update_dpoints_vl called, args: %s, kwargs: %s" % (repr(args), repr(kwargs))
        left = self.gc.get_float('/apps/maecalories/cache/day_points_left')
        ppd = self.gc.get_float('/apps/maecalories/settings/points_per_day')
        self.dpoints_vl.set_label("%.1f / %.1f" % (left, ppd))

    def update_wpoints_vl(self, *args, **kwargs):
        #print "update_wpoints_vl called, args: %s, kwargs: %s" % (repr(args), repr(kwargs))
        left = self.gc.get_float('/apps/maecalories/cache/week_points_left')
        ppw = self.gc.get_float('/apps/maecalories/settings/points_per_day') * 7
        self.wpoints_vl.set_label("%.1f / %.1f" % (left, ppw))

    def create_points_labels(self):
        container = gtk.VBox()

        dpoints_c = gtk.HBox(homogeneous=True)
        dpoints_l1 = gtk.Label("Points left:\n(day)")
        dpoints_l1.set_justify(gtk.JUSTIFY_RIGHT)
        dpoints_l1.set_alignment(xalign=1, yalign=0.5)
        dpoints_c.pack_start(dpoints_l1)
        self.dpoints_vl = gtk.Label('')
        dpoints_c.pack_start(self.dpoints_vl)
        self.update_dpoints_vl()
        self.gc.notify_add('/apps/maecalories/cache/day_points_left', self.update_dpoints_vl)
        container.pack_start(dpoints_c)

        wpoints_c = gtk.HBox(homogeneous=True)
        wpoints_l1 = gtk.Label("Points left:\n(week)")
        wpoints_l1.set_justify(gtk.JUSTIFY_RIGHT)
        wpoints_l1.set_alignment(xalign=1, yalign=0.5)
        wpoints_c.pack_start(wpoints_l1)
        self.wpoints_vl = gtk.Label('')
        wpoints_c.pack_start(self.wpoints_vl)
        self.update_wpoints_vl()
        self.gc.notify_add('/apps/maecalories/cache/week_points_left', self.update_wpoints_vl)
        container.pack_start(wpoints_c)

        container.show_all()
        return container

    def render_add_weight(self, *args):
        import weightlog
        wrapper = weightlog.create_window()
        wrapper.run()

    def render_add_points_t(self, *args):
        import pointslog
        dialog = pointslog.template_selector()
        ret = dialog.run_dialog(self.mainwindow, None)
        if ret != gtk.RESPONSE_OK:
            return
        entry = storage.midgard.mgdschema.org_maemo_garage_maecalories_pointslog(dialog.get_selected_guid())
        if entry.guid == '':
            raise Exception("Could not load selected entry")
        wrapper = pointslog.create_window(entry)
        wrapper.run()

    def render_add_points(self, *args):
        import pointslog
        wrapper = pointslog.create_window()
        wrapper.run()

    def quit(self, *args):
        """Cleanup routines and possible pre-exit confirmations"""
        gtk.main_quit()

    def mainloop(self):
        """Program entry point; draws windows and enters GTK mainloop"""
        self.mainwindow.show_all()
        # Render the progress indicator before trying to initialize storage
        hildon.hildon_gtk_window_set_progress_indicator(self.mainwindow, 1)
        while gtk.events_pending():
            gtk.main_iteration()
        storage.instance.initialize(self.mainwindow)
        hildon.hildon_gtk_window_set_progress_indicator(self.mainwindow, 0)
        gtk.main()

instance = mainwindow()