import gtk, hildon, storage

class settings:
    def __init__(self):
        self.gc = storage.instance.gc
        self.window = hildon.StackableWindow()
        self.window.set_title('Settings')
        self.window.connect('delete_event', self.save_all, None)

        # Divide to two halves
        hbox = gtk.HBox(homogeneous=True)
        self.left_column = gtk.VBox()
        hbox.add(self.left_column)
        self.right_column = gtk.VBox()
        hbox.add(self.right_column)
        self.window.add(hbox)

        self.render_points_per_day(self.left_column)
        self.render_weekday_selector(self.left_column)
        self.render_npoints_per_week(self.left_column)

#        self.savebutton = hildon.Button(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL, 'Save')
#        self.savebutton.connect('clicked', self.save_all)
#        self.right_column.pack_start(self.savebutton)

    def save_all(self, *args):
        self.save_points_per_day()
        self.save_npoints_per_week()
        self.save_weekday()
        self.window.destroy()


    def render_weekday_selector(self, container):
        ## Copied from http://pymaemo.garage.maemo.org/python_hildon_manual/hildonmigration.html#date-widgets
        self.weekday_picker = hildon.PickerButton(gtk.HILDON_SIZE_AUTO, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.weekday_picker.set_title('Week starts on:')
        #selector = hildon.hildon_touch_selector_new_text()
        selector = hildon.TouchSelector(text=True)
        
        weekdays = ['Monday', 'Tuesday', 'Thursday', 'Friday', 'Saturday', 'Sunday']
        for day_name in weekdays:
          selector.append_text(day_name)

        selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        self.weekday_picker.set_selector(selector)
        if self.gc.get_int('/apps/maecalories/settings/week_starts') != None:
            self.weekday_picker.set_active(self.gc.get_int('/apps/maecalories/settings/week_starts'))
        else:
            self.weekday_picker.set_active(0)
        
        container.pack_start(self.weekday_picker)

    def save_weekday(self, *args):
        self.gc.set_int('/apps/maecalories/settings/week_starts', self.weekday_picker.get_active())

    def render_points_per_day(self, container):
        ppd_container = gtk.HBox(homogeneous=False)
        ppd_label = gtk.Label("Points allowance:\n(per day)")
        ppd_label.set_justify(gtk.JUSTIFY_RIGHT)
        ppd_label.set_alignment(xalign=1, yalign=0.5)
        ppd_container.pack_start(ppd_label)
        self.ppd = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        if self.gc.get_float('/apps/maecalories/settings/points_per_day') != None:
            self.ppd.set_text("%0.0f" % self.gc.get_float('/apps/maecalories/settings/points_per_day'))
        self.ppd.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        ppd_container.pack_start(self.ppd)
        ppd_container.show_all()
        container.pack_start(ppd_container)

    def save_points_per_day(self, *args):
        import math
        # Since only positive values make sense cast via abs()
        self.gc.set_float('/apps/maecalories/settings/points_per_day', math.fabs(float(self.ppd.get_text())))

    def render_npoints_per_week(self, container):
        nppw_container = gtk.HBox(homogeneous=False)
        nppw_label = gtk.Label("Max negative points:\n(per week)")
        nppw_label.set_justify(gtk.JUSTIFY_RIGHT)
        nppw_label.set_alignment(xalign=1, yalign=0.5)
        nppw_container.pack_start(nppw_label)
        self.nppw = hildon.Entry(gtk.HILDON_SIZE_AUTO)
        if self.gc.get_float('/apps/maecalories/settings/npoints_per_week') != None:
            self.nppw.set_text("%0.0f" % self.gc.get_float('/apps/maecalories/settings/npoints_per_week'))
        self.nppw.set_property('hildon-input-mode', gtk.HILDON_GTK_INPUT_MODE_NUMERIC)
        nppw_container.pack_start(self.nppw)
        nppw_container.show_all()
        container.pack_start(nppw_container)

    def save_npoints_per_week(self, *args):
        import math
        # Casted to negative value even if user enters positive one
        self.gc.set_float('/apps/maecalories/settings/npoints_per_week', math.fabs(float(self.nppw.get_text())) * -1)

    def run(self):
        self.window.show_all()
