# -*- coding: utf-8 -*-
import logging
from weibopy.error import WeibopError

__author__="Michael"
__date__ ="$2011-9-1$"

from weibopy.auth import OAuthHandler, BasicAuthHandler
from weibopy.api import API
from Logger import Logger
from Writer import Writer
from Downloader import Downloader
from PyQt4.QtCore import *
import Utils
import os
import time
import dbus

APP_KEY="475214689"
APP_SECRET="f9b9d4850089e3b95a5c3e6e1d17bed5"

class UpdaterSina(QThread):
    def __init__(self,callback,parent=None, accountId=None):
        super(UpdaterSina, self).__init__(parent)
        self.logger = logging.getLogger('UpdaterSina')
        self.stopped = False
        self.mutex = QMutex()
        self.completed = False
#        self.logger =logger
        self.writer = Writer()
        self.downloader = Downloader()
        self.callback=callback
        self.logger.debug("UpdaterSina:__init__")
        self.accountId=accountId
        self.userid = 0
        self.users = []
        self.update_user_follower_pending = False

    def basicAuth(self, source, username, password):
        self.auth = BasicAuthHandler(username, password)
        self.api = API(self.auth,source=source)

    def OAuth(self, username, password):
        #self.auth = OAuthHandler(APP_KEY,APP_SECRET)
        #auth_url = self.auth.get_authorization_url()
        #print 'Please authorize: ' + auth_url
        #verifier = raw_input('PIN: ').strip()
        #self.auth.get_access_token(verifier)
        #self.api = API(self.auth)
        
        self.auth = OAuthHandler(APP_KEY,APP_SECRET)
        self.auth.setToken(username, password)
        self.api = API(self.auth)

    def initialize(self, accountId,timelineType,sinceId=None,maxId=None,countnum=20,downpic=False, optype = None, uid=None, screen_name=None):
        self.logger.debug("UpdaterSina:initialize")
        self.stopped = False
        self.accountId=accountId
        self.timelineType=timelineType
        self.sinceId=sinceId
        self.maxId=maxId
        self.countnum=countnum
        self.downpic=downpic
        self.completed = False
        self.timeline = []
        self.userinfo = []
        self.unread_counts = {}
        self.optype = optype # for clear unread counts
        self.uid = uid # for getting user detail info.
        self.screen_name = screen_name # for getting user detail info.
        self.update_user_follower_pending = False

    def stop(self):
        try:
            self.mutex.lock()
            self.stopped = True
        finally:
            self.mutex.unlock()


    def is_stopped(self):
        try:
            self.mutex.lock()
            return self.stopped
        finally:
            self.mutex.unlock()

    def run(self):
        self.logger.debug("run")
        try:
            if self.update_user_follower_pending != False:
                self.update_user_follower_pending = False
                self.update_user_follower_process()
            else:
                self.update_timeline(self.sinceId,self.maxId,self.countnum)
        except WeibopError,we:
            self.completed=False
            self.emit(SIGNAL("finished(bool)"),self.completed)
            self.emit(SIGNAL("show_notice(QString,int)"),we.reason,0)
        self.stop()
        
    def get_userid(self):
        ''' get current account userid'''
        
        if self.userid == 0:
            user = self.api.verify_credentials()
            if user:
                self.userid = user.id
            else:
                print "get_userid failed"
        return self.userid

        
    def get_friendship(self, user):
        #print "get_friendship2me"
        param={}
        param["target_id"]=user['id']
        (source, target) = self.api.show_friendship(**param)
        #print target.screen_name, target.following, target.followed_by

        friendship = {}
        #friendship["id"] = target.id
        if target.id == self.get_userid():
            friendship["self"] = True
        else:
            friendship["self"] = False
            
        friendship["following"] = target.following
        friendship["followed_by"] = target.followed_by  
            
        return friendship

    def update_user_follower(self, uid, accountid, downpic, cursor = -1, getFans = False, count = 20):
        #print "update_user_follower"
        self.users = []
        self.uid = uid
        self.accountId = accountid
        self.downpic=downpic
        
        self.param={}
        self.param["user_id"]=uid
        self.param["cursor"]=cursor
        self.param["count"]=count
        self.update_user_follower_pending = True
        self.getFans = getFans
        
    def update_user_follower_process(self):
        #print "update_user_follower_process"
        users = None
        if self.getFans:        
            #print "update_user_follower_process: fans"
            users = self.api.followers(**self.param)
        else:
            #print "update_user_follower_process: friends"
            users = self.api.friends(**self.param)
        #print target.screen_name, target.following, target.followed_by

        #print users.next_cursor
        self.next_cursor = users.next_cursor
        
        if users.users != None:
            for obj in users.users:
                user = Utils.build_a_user_from_obj(obj, self.accountId)
                self.users.append(user)
                #print user
                
                status = user['status']
                
                # download images.
                #print str(time.time()) + ": " + "Begin downloading images"
                if status != None and self.downpic=="True":
                    thumbnail=status["thumbnail_pic"]
                    if thumbnail!=None:
                        filename=thumbnail.split("/")[-1]
                        picFilename=Utils.THUMBNAIL_DIR+str(self.accountId)+"_"+str(status["id"])+"_"+filename
                        if os.access(picFilename, os.W_OK) == 0:
                            picSource=self.downloader.download(thumbnail)
                            self.writer.write_to(picFilename, picSource)
                    
                    avatar=user["profile_image_url"]
                    if avatar!=None:
                        picFilename=Utils.AVATAR_DIR+str(self.accountId)+"_"+str(user["id"])
                        if os.access(picFilename, os.W_OK) == 0:
                            picSource=self.downloader.download(avatar)
                            self.writer.write_to(picFilename, picSource)

        if users.next_cursor == 0:
            hasnext = False
        else:
            hasnext = True
            
        self.emit(SIGNAL("userlist_finished(bool)"), hasnext)

    def update_timeline(self,sinceId=None,maxId=None,countNum=20,pageNum=1):
        #print "update_timeline"
        self.logger.debug("update_timeline")
        param={}
        param["count"]=countNum
        param["page"]=pageNum
        if sinceId!=None and self.timelineType!=Utils.TIMELINE_TYPE_ST_COMMENTS:
            param["since_id"]=sinceId
        else:
            param["id"]=sinceId
        if maxId!=None and self.timelineType!=Utils.TIMELINE_TYPE_ST_COMMENTS:
            param["max_id"]=maxId
        timeline=None
        #print str(time.time()) + ": Before updater update_timeline"
        if self.timelineType==Utils.TIMELINE_TYPE_FRIENDS:
            timeline = self.api.friends_timeline(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_DM:
            timeline = self.api.user_timeline(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_MENTIONS:
            timeline = self.api.mentions(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_COMMENTS:
            timeline = self.api.comments_timeline(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_ST_COMMENTS:
            timeline = self.api.comments(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_FAVOUR:
            param={}
            param["source"]=APP_KEY
            param["id"]=1863105202
            timeline = self.api.favorites(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_UNREAD:
            param={}
            param["with_new_status"]=0
            timeline = self.api.unread(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_DEUNREAD:
            param={}
            #print "update_timeline, optype", self.optype
            if self.optype == Utils.TIMELINE_TYPE_MENTIONS:
                param["type"]=2
            elif self.optype == Utils.TIMELINE_TYPE_COMMENTS:    
                param["type"]=1
            elif self.optype == Utils.TIMELINE_TYPE_FAVOUR:    
                param["type"]=4
            timeline = self.api.reset_count(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_USER_SHOW:
            param={}
            #print "update_timeline, optype", self.optype
            if self.screen_name == None:
                param["user_id"]=self.uid
            else:
                param["screen_name"]=self.screen_name
            timeline = self.api.get_user(**param)
        elif self.timelineType==Utils.TIMELINE_TYPE_USER_TIMELINE:
            #print "update_timeline, uid", self.uid
            
            param["user_id"]=self.uid
            #param["screen_name"]=self.screen_name
            timeline = self.api.user_timeline(**param)

        #print str(time.time()) + ": " + "After updater update_timeline"

        counts = None
        if self.timelineType == Utils.TIMELINE_TYPE_USER_SHOW and timeline!=None:
            self.user = Utils.build_a_user_from_obj(timeline, self.accountId)
            self.user["avatar_large"] = self.user["profile_image_url"].replace("/50/", "/180/")
            #print self.user["avatar_large"],  self.user["profile_image_url"]
        elif self.timelineType != Utils.TIMELINE_TYPE_UNREAD and self.timelineType != Utils.TIMELINE_TYPE_DEUNREAD and timeline!=None:
            param_id = {}
            param_id["ids"]=""
            tmp_flag = 0
            for line in timeline:     
                status=Utils.build_a_status_from_obj(line,self.accountId)

                if tmp_flag == 0:
                    param_id["ids"] = str(status["id"])
                    tmp_flag = 1
                else:
                    param_id["ids"] = param_id["ids"] + "," + str(status["id"])
                                              
                self.timeline.append(status)
                            
                # download images.
                #print str(time.time()) + ": " + "Begin downloading images"
                if self.downpic=="True":
                    thumbnail=status["thumbnail_pic"]
                    if thumbnail!=None:
                        filename=thumbnail.split("/")[-1]
                        picFilename=Utils.THUMBNAIL_DIR+str(self.accountId)+"_"+str(status["id"])+"_"+filename
                        if os.access(picFilename, os.W_OK) == 0:
                            picSource=self.downloader.download(thumbnail)
                            self.writer.write_to(picFilename, picSource)
                    user=status["user"]
                    
                    avatar=user["profile_image_url"]
                    if avatar!=None:
                        picFilename=Utils.AVATAR_DIR+str(self.accountId)+"_"+str(user["id"])
                        if os.access(picFilename, os.W_OK) == 0:
                            picSource=self.downloader.download(avatar)
                            self.writer.write_to(picFilename, picSource)

                    rtStatus=status["retweeted_status"]
                    if rtStatus!=None:
                        rtUser=rtStatus["user"]
                        rtAvatar=rtUser["profile_image_url"]
                        if rtAvatar!=None:
                            picFilename=Utils.AVATAR_DIR+str(self.accountId)+"_"+str(rtUser["id"])
                            if os.access(picFilename, os.W_OK) == 0:
                                picSource=self.downloader.download(rtAvatar)
                                self.writer.write_to(picFilename, picSource)
                        rtThumbnail=rtStatus["thumbnail_pic"]
                        if rtThumbnail!=None:
                            filename=rtThumbnail.split("/")[-1]
                            picFilename=Utils.THUMBNAIL_DIR+str(self.accountId)+"_"+str(rtStatus["id"])+"_"+filename
                            if os.access(picFilename, os.W_OK) == 0:
                                picSource=self.downloader.download(rtThumbnail)
                                self.writer.write_to(picFilename, picSource)
                #print str(time.time()) + ": " + "After downloading images"
        elif self.timelineType == Utils.TIMELINE_TYPE_UNREAD:  
            self.unread_counts = Utils.build_a_unread_count_from_obj(timeline)
        
        if (self.timelineType==Utils.TIMELINE_TYPE_FRIENDS or \
            self.timelineType==Utils.TIMELINE_TYPE_USER_TIMELINE) and param_id["ids"]!="": 
            counts = self.api.counts(**param_id)
            for _count in counts:
                tmp_count = Utils.build_a_count_from_obj(_count,self.accountId)
                #print "+++counts: " + str(tmp_count["id"]), str(tmp_count["comments"]), str(tmp_count["rt"])
                for status in self.timeline:
                    if status["id"] == tmp_count["id"]:
                        #print "====" + str(status["id"])
                        status["cm_num"] = tmp_count["comments"]
                        status["rt_num"] = tmp_count["rt"]

        #print str(time.time()) + ": After build_a_status"

        self.completed = True
        if self.timelineType==Utils.TIMELINE_TYPE_UNREAD:
            self.emit(SIGNAL("unread_finished(int)"),self.accountId)
        elif self.timelineType==Utils.TIMELINE_TYPE_USER_SHOW:
            #print self.uid
            self.emit(SIGNAL("user_finished(QString, QString)"), str(self.uid), str(self.screen_name))
        elif self.timelineType!=Utils.TIMELINE_TYPE_ST_COMMENTS and self.timelineType!=Utils.TIMELINE_TYPE_DEUNREAD:   
            self.emit(SIGNAL("finished(bool)"),self.completed)
        elif self.timelineType == Utils.TIMELINE_TYPE_ST_COMMENTS:
            self.emit(SIGNAL("cm_finished(bool)"),self.completed)
        self.logger.info("update completed!")

class SenderSina(QThread):
    def __init__(self,callback,parent=None):
        super(SenderSina, self).__init__(parent)
        self.logger = logging.getLogger('SenderSina')
        self.stopped = False
        self.mutex = QMutex()
        self.completed = False
        self.callback=callback
#        self.logger =logger
#        self.writer = Writer()
#        self.downloader = Downloader()
        self.logger.debug("SenderSina:__init__")


    def basicAuth(self, source, username, password):
        self.auth = BasicAuthHandler(username, password)
        self.api = API(self.auth,source=source)

    def OAuth(self, token, tokenSecret):
        self.auth = OAuthHandler(APP_KEY,APP_SECRET)
        self.auth.setToken(token, tokenSecret)
        self.api = API(self.auth)

    def initialize(self, accountId,param):
        self.logger.debug("SenderSina:initialize")
        self.stopped = False
        self.accountId=accountId
        self.param=param
        self.completed = False
                
    def stop(self):
        try:
            self.mutex.lock()
            self.stopped = True
        finally:
            self.mutex.unlock()


    def is_stopped(self):
        try:
            self.mutex.lock()
            return self.stopped
        finally:
            self.mutex.unlock()

    def run(self):
        self.logger.debug("run")
        try:
            self.send(self.param)
        except WeibopError,we:
            self.completed=False
            self.emit(SIGNAL("finished(bool)"),self.completed)
            self.emit(SIGNAL("show_notice(QString,int)"),we.reason,0)
        self.stop()


    def send(self, param):
        self.logger.debug("sending")
        param["source"]=APP_KEY
        
        #param["long"]="121.453292"
        #param["lat"]="31.269765"
        
        self.logger.debug(param)
        timelineType=param["timelineType"]
        
        
        
        if timelineType==None:
            self.logger.debug("send a normal msg")
#            if hasattr(param, 'pic'):
            try:
                pic=str(param["pic"])
                self.logger.debug("with a picture:"+pic)
                status=self.api.upload(pic,str(param["status"]),None,None,param["source"])
            except KeyError,ae:
#            else:
                self.logger.error(os.sys.exc_info()[0])
                self.logger.debug(ae)
                self.logger.debug("just a text msg")
                status=self.api.update_status(**param)
                
        elif timelineType==Utils.TIMELINE_TYPE_MENTIONS:
            self.logger.debug("send a rt")
            #rt
            status=self.api.repost(**param)
        elif timelineType==Utils.TIMELINE_TYPE_COMMENTS:
            #comment
            self.logger.debug("send a comment")
            #rt it first
            try:
                if param["without_mention"]==2:
                    param1={}
                    param1["id"]=param["id"]
                    param1["status"]=param["comment"]+param["retext"]
                    #print  " param1[status]" + param1["status"] + " id : " + str( param1["id"])
                    param["without_mention"]=0
                    param["retext"] =None
                    #print "id" + str(param1["id"]) + "   cid" + str(param["cid"])
                    status=self.api.repost(**param1)
                #print  " param[comment]" + param["comment"] + " id : " + str( param["id"])
                status=self.api.comment(**param)
            except KeyError,ae:
                #print  " param[comment]" + param["comment"] + " id : " + str( param["id"])
                status=self.api.comment(**param)
        elif timelineType==Utils.TIMELINE_TYPE_DM:
            #dm
            self.logger.debug("send a dm")
            status=self.api.new_direct_message(**param)
        self.completed = True
        self.emit(SIGNAL("finished(bool)"),self.completed)
        self.logger.info("sending completed!")
        
    def add_follower(self, screen_name):
        #print "add_follower"
        param={}
        param["screen_name"]=screen_name
        self.api.create_friendship(**param)
    def delete_follower(self, screen_name):
        #print "add_follower"
        param={}
        param["screen_name"]=screen_name
        self.api.destroy_friendship(**param)

