# -*- coding: utf-8 -*-

__author__= "Michael Wong"
__email__="imichaelwong@gmail.com"
__version__= "0.1.0"
__build__="110101"

import platform
import sys
import string
import os
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtWebKit import *
import Utils
#from PyQt4.QtMaemo5 import *
#from flickcharm import *
from PyQt4.QtGui import *

class WebsitesModel(QAbstractListModel):
    def __init__(self, websites=None, parent=None):
        super(WebsitesModel, self).__init__(parent)
        self.websites=websites

    def rowCount(self,parent=None):
        return len(self.websites)

    def data(self,index,role= Qt.DisplayRole):
        if not index.isValid():
            return None
        if (index.row() >= len(self.websites)):
            return None
        if (role == Qt.DisplayRole):
            website=self.websites[index.row()]
            source="""
            <tr style="font-size:22px;color:#FFFFFF">
                <td>%s</td>
                <td align="left">%s</td>
            </tr>
            </table>
            """
            html="<table width=\"80%\" border=\"0\">"+source % (unicode(website["name"]), website["indexUrl"])
            return html
        else:
            return self.websites[index.row()]

class AccountsModel(QAbstractListModel):
    def __init__(self,accounts=None,websites=None, parent=None):
        super(AccountsModel, self).__init__(parent)
        self.accounts=accounts
        self.websites=websites


    def rowCount(self,parent=None):
        return len(self.accounts)

    def data(self,index,role= Qt.DisplayRole):
        if not index.isValid():
            return None
        if (index.row() >= len(self.accounts)):
            return None
        if (role == Qt.DisplayRole):
            account=self.accounts[index.row()]
            username=account["nickname"]
            return username
        if (role==Utils.ROLE_AVATAR):
            account=self.accounts[index.row()]
            website=None
            for web in self.websites:
                if web["id"]==account["website"]:
                    website=web
                    break
            icon=Utils.ICONS_DIR+website["icon"]
            return icon
        else:
            return self.accounts[index.row()]["id"]

class MenusModel(QAbstractListModel):
    def __init__(self,menus=None, parent=None):
        super(MenusModel, self).__init__(parent)
        self.menus=menus
        self.unread_counts = {}
        for attr in Utils.UNREAD_ATT_COUNTS:
            self.unread_counts[attr] = 0

    def rowCount(self,parent=None):
        return len(self.menus)

    def data(self,index,role= Qt.DisplayRole):
        if not index.isValid():
            return None
        if (index.row() >= len(self.menus)):
            return None
        if (role == Qt.DisplayRole):
            menu=self.menus[index.row()]["name"]
#            html=self.makeMenuHtml(menu)
            return menu
            
        if (role == Utils.ROLE_UNREAD):
            #print "<Utils.ROLE_UNREAD"
           #print self.get_unread_counts(index.row())
            #print "Utils.ROLE_UNREAD>"
            return self.get_unread_counts(index.row())
            
        if (role==Utils.ROLE_AVATAR):
            return self.menus[index.row()]["icon"]
        else:
            return self.menus[index.row()]["value"]
    def get_unread_counts(self, menu_row):  
        if menu_row == 1:
            #print "get_unread_counts: mentions"
            return self.unread_counts["mentions"]
        elif menu_row == 2:

            #print "get_unread_counts: comments"
            return self.unread_counts["comments"]
        elif menu_row == 4:

            #print "get_unread_counts: comments"
            return self.unread_counts["followers"]
        else:
            #print "===NA==="
            return 0
            
    def set_unread_counts(self, unread_counts):
        try:
            for attr in Utils.UNREAD_ATT_COUNTS:
                self.unread_counts[attr] = unread_counts[attr]
        except:
            self.unread_counts[attr] = 0
            
    def clear_unread_count(self, optype):
        if optype == Utils.TIMELINE_TYPE_MENTIONS:
            self.unread_counts["mentions"] = 0
            #print "clear_unread_count: mentions"
        elif optype == Utils.TIMELINE_TYPE_COMMENTS:
            self.unread_counts["comments"] = 0
            #print "clear_unread_count: comments"
        elif optype == Utils.TIMELINE_TYPE_FAVOUR:
            self.unread_counts["followers"] = 0
            #print "clear_unread_count: comments"
        else:
            print "clear_unread_count: not support"
            
    def need_clear_unread_count(self, optype):
        if optype == Utils.TIMELINE_TYPE_MENTIONS and self.unread_counts["mentions"] > 0:
            #print "need_clear_unread_count: mentions need clear"
            return True
        elif optype == Utils.TIMELINE_TYPE_COMMENTS and self.unread_counts["comments"] > 0:
            #print "clear_unread_count: comments need clear"
            return True
        elif optype == Utils.TIMELINE_TYPE_FAVOUR and self.unread_counts["followers"] > 0:
            #print "clear_unread_count: fans need clear"
            return True
        else:
            #print "clear_unread_count: not support"
            return False

            
         
class StatusModel(QAbstractListModel):
    def __init__(self, statuses=None, parent=None):
        super(StatusModel, self).__init__(parent)
        self.statuses=statuses

    def rowCount(self,parent=None):
        return len(self.statuses)

    def data(self,index,role= Qt.DisplayRole):
        status=self.statuses[index.row()]

        if (role==Utils.ROLE_CM_NUM):
            return status["cm_num"]
        if (role==Utils.ROLE_RT_NUM):
            return status["rt_num"]
            
        #test if an operation
        if (role==Utils.ROLE_TEST_OPERATION):
            try:
                type=status["type"]
                return True
            except KeyError,ke:
                return False
        #test if a gap
        if (role==Utils.ROLE_TEST_GAP):
            if status["if_gap"]:
                return True
            else:
                return False

        #it is an operation
        if (role==Utils.ROLE_OPERATION):
            #it is an operation
            name=status["name"]
            lastUpdated=status["lastUpdated"]
            if lastUpdated!=None:
                return name+"\nLast updated at: "+lastUpdated
            else:
                return name

        #it is a status

        if (role==Utils.ROLE_ID):
            #print "status -> id:"
            #print str(status["id"]) + "===" + str(status["status_id"])
            return status["status_id"]
        if (role == Qt.DisplayRole):
            return status["text"]

        if (role == Utils.ROLE_AVATAR):
            user=status["user"]
            userImage=Utils.AVATAR_DIR+str(status["account"])+"_"+str(user["id"])
            if platform.os.access(userImage, platform.os.W_OK) == 0:
                userImage=Utils.DEFAULT_AVATAR_FILE
            return userImage
        if (role == Utils.ROLE_NAME):
            user=status["user"]
            return user["name"]
        if (role == Utils.ROLE_SCREENNAME):
            user=status["user"]
            return user["screen_name"]
        if (role == Utils.ROLE_ISVERIFIED):
            user=status["user"]
            return user["verified"]
        if (role == Utils.ROLE_TIME):
            createdAt=status["created_at"]
            time=Utils.gene_datetime_string(createdAt)
            return time
        if (role == Utils.ROLE_THUMBNAIL):
            thumbnailPic=status["thumbnail_pic"]
            
            if thumbnailPic!=None:
                filename=thumbnailPic.split("/")[-1]
                if len(filename)==0 or filename=="460":
                    filename=thumbnailPic.split("/")[-2]
                    
                thumbnailPic=Utils.THUMBNAIL_DIR+str(status["account"])+"_"+str(status["id"])+"_"+filename
                if os.access(thumbnailPic, platform.os.W_OK) == 0:
                    #thumbnailPic=None
                    thumbnailPic=Utils.ICONS_DIR+"defaultpic.png"
            return thumbnailPic

        rt=None
        rtUser=None
        rtName=None
        rtScreenName=None
        rtText=None
        rtThumbnailPic=None
        try:
            rt=status["retweeted_status"]
        except KeyError,ke:
            return

        if rt!=None:
            rtUser=rt["user"]
            rtName=rtUser["name"]
            rtScreenName=rtUser["screen_name"]
            rtText=rt["text"]
            rtUserImage=Utils.AVATAR_DIR+str(status["account"])+"_"+str(rtUser["id"])
            if platform.os.access(rtUserImage, platform.os.W_OK) == 0:
                rtUserImage=Utils.DEFAULT_AVATAR_FILE
            rtThumbnailPic=rt["thumbnail_pic"]
            if rtThumbnailPic!=None:
                filename=rtThumbnailPic.split("/")[-1]
                rtThumbnailPic=Utils.THUMBNAIL_DIR+str(status["account"])+"_"+str(rt["id"])+"_"+filename
                if os.access(rtThumbnailPic, platform.os.W_OK) == 0:
                    #rtThumbnailPic=Utils.ICONS_DIR+"_options_favorite_big.png"
                    rtThumbnailPic=Utils.ICONS_DIR+"defaultpic.png"
        if (role == Utils.ROLE_RT_NAME):
            return rtName
        if (role == Utils.ROLE_RT_SCREENNAME):
            return rtScreenName
        if (role == Utils.ROLE_RT_TEXT):
            return rtText
        if (role == Utils.ROLE_RT_AVATAR):
            return rtUserImage
        if (role == Utils.ROLE_RT_THUMBNAIL):
            return rtThumbnailPic

         
class UserModel(QAbstractListModel):
    def __init__(self, users=None, parent=None):
        super(UserModel, self).__init__(parent)
        self.users=users

    def rowCount(self,parent=None):
        return len(self.users)

    def data(self,index,role= Qt.DisplayRole):
        user=self.users[index.row()]
        #print "userModel:", index,index.row(),role, user["name"]
        
        #test if an operation
        if (role==Utils.ROLE_TEST_OPERATION):
            try:
                type=user["type"]
                return True
            except KeyError,ke:
                return False
        #test if a gap
        if (role==Utils.ROLE_TEST_GAP):
            if user["if_gap"]:
                return True
            else:
                return False

        #it is an operation
        if (role==Utils.ROLE_OPERATION):
            #it is an operation
            name=user["name"]
            lastUpdated=user["lastUpdated"]
            if lastUpdated!=None:
                return name+"\nLast updated at: "+lastUpdated
            else:
                return name

        #it is a user
        if (role==Utils.ROLE_ID):
            #print "user -> id:"
            #print str(user["id"]) + "===" + str(user["user_id"])
            return user["id"]

        if (role == Utils.ROLE_AVATAR):
            userImage=Utils.AVATAR_DIR+str(user["account"])+"_"+str(user["id"])
            if platform.os.access(userImage, platform.os.W_OK) == 0:
                userImage=Utils.DEFAULT_AVATAR_FILE
            return userImage
        if (role == Utils.ROLE_NAME):
            return user["name"]
        if (role == Utils.ROLE_SCREENNAME):
            return user["screen_name"]
        if (role == Utils.ROLE_ISVERIFIED):
            return user["verified"]             
        if (role == Utils.ROLE_STATUSES):
            return user["statuses_count"]    
        if (role == Utils.ROLE_FRIENDS):
            return user["followers_count"]
        if (role == Utils.ROLE_FOLLOWERS):
            return user["friends_count"]
        if (role == Utils.ROLE_LOCATION):
            return user["location"]
        if (role == Utils.ROLE_GENDER):
            return user["gender"]
        
        #print user['name']
        status = user['status']
        if status != None:
            if (role == Qt.DisplayRole):
                return status["text"]
    
            if (role == Utils.ROLE_TIME):
                createdAt=status["created_at"]
                time=Utils.gene_datetime_string(createdAt)
                return time
            if (role == Utils.ROLE_THUMBNAIL):
                thumbnailPic=status["thumbnail_pic"]
                
                if thumbnailPic!=None:
                    filename=thumbnailPic.split("/")[-1]
                    if len(filename)==0 or filename=="460":
                        filename=thumbnailPic.split("/")[-2]
                        
                    thumbnailPic=Utils.THUMBNAIL_DIR+str(user["account"])+"_"+str(status["id"])+"_"+filename
                    if os.access(thumbnailPic, platform.os.W_OK) == 0:
                        thumbnailPic=Utils.ICONS_DIR+"defaultpic.png"
                return thumbnailPic
        else:
            if (role == Qt.DisplayRole):
                return ""
    
            if (role == Utils.ROLE_TIME):
                return ""
            if (role == Utils.ROLE_THUMBNAIL):
                return None