# -*- coding: utf-8 -*-

"""
DataModel:
    Status{
    # the below are nWeiBo specific.
        status_id: the id
        account: id of the account who get the tweet
        if_rt:  boolean,true as a inner tweet.
        author: same as user

    # the below come from sina weibo sdk
        created_at: 创建时间
        id: 微博ID
        text: 微博信息内容
        source: 微博来源
        favorited: 是否已收藏
        truncated: 是否被截断
        in_reply_to_status_id: 回复ID
        in_reply_to_user_id: 回复人UID
        in_reply_to_screen_name: 回复人昵称
        thumbnail_pic: 缩略图
        bmiddle_pic: 中型图片
        original_pic：原始图片
        user: 作者信息
        retweeted_status: 转发的博文，内容为status，如果不是转发，则没有此字段
        }

    User(
    # the below are nWeiBo specific.
        user_id: the id
        account:


    # the below come from sina weibo sdk
        id: 用户UID
        screen_name: 微博昵称
        name: 友好显示名称，如Bill Gates(此特性暂不支持)
        province: 省份编码（参考省份编码表）
        city: 城市编码（参考城市编码表）
        location：地址
        description: 个人描述
        url: 用户博客地址
        profile_image_url: 自定义图像
        domain: 用户个性化URL
        gender: 性别,m--男，f--女,n--未知
        followers_count: 粉丝数
        friends_count: 关注数
        statuses_count: 微博数
        favourites_count: 收藏数
        created_at: 创建时间
        following: 是否已关注(此特性暂不支持)
        verified: 加V标示，是否微博认证用户
        }
"""

import string
from datetime import datetime
import time
from Exceptions import *
from PyQt4.QtCore import *

g_orietation = 0


#these are for testing
#INSTALL_PATH="/home/user/MyDocs/maebo/src/maebo/"
#DATA_FILE_PATH="/home/user/MyDocs/maebo/test/"

INSTALL_PATH="/opt/maebo/"
DATA_FILE_PATH="/home/user/MyDocs/.maebo/"

THUMBNAIL_DIR=DATA_FILE_PATH+"thumbnail/"
AVATAR_DIR=DATA_FILE_PATH+"avatar/"
ICONS_DIR=INSTALL_PATH+"icons/"


LOG_FILE=DATA_FILE_PATH+"maebo.log"
DATA_DB_FILE=DATA_FILE_PATH+"maebo_data.db"
WEBSITE_DB_FILE=INSTALL_PATH+"maebo_w.db"
DEFAULT_AVATAR_FILE=ICONS_DIR+"default_avatar.jpg"
VERIFIED_FILE=ICONS_DIR+"verified.png"

COLOR_BACKGROUND="#edf1f2"
COLOR_BACKGROUND_ALT="#e6eaeb"

ROLE_AVATAR=99
ROLE_TIME=98
ROLE_NAME=97
ROLE_ISVERIFIED=85
ROLE_SCREENNAME=87
ROLE_THUMBNAIL=96
ROLE_RT_TEXT=95
ROLE_RT_NAME=94
ROLE_RT_SCREENNAME=86
ROLE_RT_AVATAR=93
ROLE_ID=92
ROLE_RT_THUMBNAIL=91
ROLE_TEST_OPERATION=90
ROLE_OPERATION=89
ROLE_TEST_GAP=88

ROLE_CM_NUM=83
ROLE_RT_NUM=84
ROLE_UNREAD = 82

SETTINGS_ATT_NAMES=[
        "downpic",
        "updatenum",
        "background",
        "updateinterval",
        "notify_led",
        "notify_vibra",
        "notify_sound",
        "updateinterval2",
        "down_orgpic",
        "auto_conn"
        ]
        
STATUS_ATT_COUNTS=[
        "id",
        "comments",
        "rt",
        ]
        
UNREAD_ATT_COUNTS=[
        "comments",
        "followers",
        "dm",
        "mentions",
        ]
        
UNREAD_ATT_COUNTS_QQ=[
        "home",
        "create",
        "fans",
        "private",
        "mentions",
        ]


STATUS_ATT_NAMES=[
        "status_id",
        "account",
        "author",
        "if_rt",
        "if_friends",
        "if_dm",
        "if_mentions",
        "if_comments",
        "if_gap",

        "id",
        "text",
        "source",
        "source_url",
        "favorited",
        "truncated",
        "in_reply_to_status_id",
        "in_reply_to_user_id",
        "in_reply_to_screen_name",
        "thumbnail_pic",
        "bmiddle_pic",
        "created_at",
        "original_pic",
        "user",
        "retweeted_status",
        "cm_num",
        "rt_num",
        "status",
        "reply_comment",
        ]
USER_ATT_NAMES=[
        "user_id",
        "account",

        "id",
        "screen_name",
        "name",
        "province",
        "city",
        "location",
        "description",
        "url",
        "profile_image_url",
        "domain",
        "gender",
        "followers_count",
        "friends_count",
        "statuses_count",
        "favourites_count",
        "created_at",
        "following",
        "verified"
        ]

ACCOUNT_ATT_NAMES=[
        "id",
        "website",
        "nickname",
        "username",
        "password",
        "auto_update",
        "last_update_time_friends",
        "last_update_time_mentions",
        "last_update_time_comments",
        "last_update_time_dm",
        "last_update_time_favour"
        ]

STATUS_OPE_TYPE_UPDATE=1
STATUS_OPE_TYPE_MORE=2
STATUS_OPE_TYPE_GAP=3
STATUS_OPE_TYPE_COMMENT=3

TIMELINE_TYPE_FRIENDS=1
TIMELINE_TYPE_DM=2
TIMELINE_TYPE_MENTIONS=3
TIMELINE_TYPE_COMMENTS=4
TIMELINE_TYPE_FAVOUR=5
TIMELINE_TYPE_ST_COMMENTS=6
TIMELINE_TYPE_UNREAD=7
TIMELINE_TYPE_DEUNREAD=8

NEW_A_STATUS=11


def build_menus():
    menuString=["我的首页","提到我的","我的评论","我的广播","我的收藏","发表微博"]
    menuValues=[TIMELINE_TYPE_FRIENDS,TIMELINE_TYPE_MENTIONS,
                         TIMELINE_TYPE_COMMENTS,TIMELINE_TYPE_DM,
                         TIMELINE_TYPE_FAVOUR,NEW_A_STATUS]
    menuIcons=[ICONS_DIR+"menu_home.png",ICONS_DIR+"menu_mention.png",
               ICONS_DIR+"menu_comment.png",ICONS_DIR+"menu_message.png",
               ICONS_DIR+"menu_favorite.png",ICONS_DIR+"menu_compose.png"]
    result = []
    for i in range(6):
        menu={}
        menu["name"]=menuString[i]
        menu["value"]=menuValues[i]
        menu["icon"]=menuIcons[i]
        result.append(menu)
    return result


def build_an_operation(type,name,lastUpdated):
    result={}
    result["type"]=type
    result["name"]=name
    result["lastUpdated"]=lastUpdated
    return result

def build_a_status_from_row(obj):
    if obj==None:
        return None
    result = {}
    for att in STATUS_ATT_NAMES:
        try:
            result[att]=obj[att]
        except AttributeError:
            result[att]=None
    return result
    
def build_settings_from_row(obj):
    result = {}
    
    if obj==None:
        result["downpic"]="False"
        result["background"]="False"
        result["updatenum"]="10"
        result["updateinterval"]="1"
        result["updateinterval2"]="10"
        result["notify_led"]="True"
        result["notify_vibra"]="False"
        result["notify_sound"]="True"
        result["down_orgpic"]="True"
        result["auto_conn"]="---None---"
        return result
        
    for att in SETTINGS_ATT_NAMES:
        try:
            result[att]=str(obj[att])
        except AttributeError:
            result[att]=None
    return result

def build_a_gap_status(accountId):
    result = {}
    for att in STATUS_ATT_NAMES:
        result[att]=None
    result["if_gap"]=1
    result["if_friends"]=0
    result["if_dm"]=0
    result["if_mentions"]=0
    result["if_comments"]=0
    result["if_rt"]=0
    result["account"]=accountId
    result["text"]="Click to eliminate the gap"
    return result


def build_a_user_from_row(obj):
    if obj==None:
        return None
    result = {}
    for att in USER_ATT_NAMES:
        try:
            result[att]=obj[att]
        except AttributeError:
            result[att]=None
    return result

def build_an_empty_account():
    result = {}
    for att in ACCOUNT_ATT_NAMES:
        result[att]=None
    return result


def build_an_account_from_row(obj):
    if obj==None:
        return None
    result = {}
    for att in ACCOUNT_ATT_NAMES:
        try:
            result[att]=obj[att]
        except AttributeError:
            result[att]=None
    return result

def build_a_status_from_obj(obj,accountId):
    #print "build_a_status_from_obj"
    result = {}
    for att in STATUS_ATT_NAMES:
        try:
            result[att]=getattr(obj,att)
        except AttributeError:
            #print att
            result[att]=None
    result["if_gap"]=0
    result["if_friends"]=0
    result["if_dm"]=0
    result["if_mentions"]=0
    result["if_comments"]=0
    result["account"]=accountId
    #if result["user"]==None:
        #for sina DM,there is no user but a sender.
    #    result["user"]=getattr(obj,"sender")
    user=build_a_user_from_obj(result["user"],accountId)
    result["user"]=user
    result["author"]=user
    result["if_rt"]=False
    result["cm_num"]=0
    result["rt_num"]=0
    
    # FUck SInA ApI!!!
    
    #print "Debug!"
    #dump(obj)
    #print "============================"
    #dump(getattr(obj,"parse"))
    
    #result["if_dm"]=getattr(obj,"status")["id"]
    #print "FucK SinA"
    #print result["if_dm"]

    rt=result["retweeted_status"]
    if rt!=None:
        rtStatus=build_a_status_from_obj(rt,accountId)
        rtStatus["if_rt"]=True
        result["retweeted_status"]=rtStatus

    s=result["status"]
    if s!=None:
        sStatus=build_a_status_from_obj(s,accountId)
        sStatus["if_cs"]=True
        result["status"]=sStatus
        
    reply_comment=result["reply_comment"]
    if reply_comment!=None:
        reply_commentStatus=build_a_status_from_obj(reply_comment,accountId)
        result["reply_comment"]=reply_commentStatus
                
    return result

def build_a_count_from_obj(obj,accountId):
    result = {}
    for att in STATUS_ATT_COUNTS:
        try:
            result[att]=getattr(obj,att)
        except AttributeError:
            result[att]=None
    return result        

def build_a_unread_count_from_obj(obj):
    result = {}
    for att in UNREAD_ATT_COUNTS:
        try:
            result[att]=getattr(obj,att)
            #print att, result[att]
        except AttributeError:
            result[att]=0
            #print att, result[att]
    return result     
    
def build_a_unread_count_from_obj_qq(obj):
    result = {}
    for att in UNREAD_ATT_COUNTS:
        #print att
        try:
            result[att]=obj[att]
            #print att, result[att]
        except:
            result[att]=0
            #print att, result[att]
    return result    



def dump(obj):
    for attr in dir(obj):
        print "obj.%s = %s" % (attr, getattr(obj, attr))
    
def build_a_user_from_obj(obj,accountId):
    result = {}
    for att in USER_ATT_NAMES:
        try:
            result[att]=getattr(obj,att)
        except AttributeError:
            result[att]=None
    result["account"]=accountId
    return result


def build_a_status_from_obj_qq(obj,accountId):
    result = {}
    
    result["id"]=int(obj["id"])
    result["text"]=obj["text"]
    result["source"]=obj["from"]
    result["source_url"]=obj["from"]
    result["created_at"]=toDateTime(obj["timestamp"])
    
    result["favorited"]=0
    result["truncated"]=0
    
    result["in_reply_to_status_id"]=0
    result["in_reply_to_user_id"]=0
    result["in_reply_to_screen_name"]=None
    
    result["thumbnail_pic"]=doParseImages(obj["image"], "thumbnail")
    result["bmiddle_pic"]=str(obj["timestamp"])
    result["original_pic"]=doParseImages(obj["image"], "original")
    
    result["if_gap"]=0
    result["if_friends"]=0
    result["if_dm"]=0
    result["if_mentions"]=0
    result["if_comments"]=0
    result["account"]=accountId

    result["cm_num"] = obj["mcount"]
    result["rt_num"] = obj["count"]
    
    user=build_a_user_from_obj_qq(obj,accountId)
    result["user"]=user
    result["author"]=user
    result["if_rt"]=False
    result["retweeted_status"]=None
    if obj["type"]==2:
        rtStatus=build_a_status_from_obj_qq(obj["source"],accountId)
        rtStatus["if_rt"]=True
        
        result["retweeted_status"]=rtStatus

    result["status"]=None
    result["reply_comment"]=None
    
    return result

def doParseImages(strImages, strType):
    if strImages!=None:
        strImages = str(strImages)
        strImages = strImages.replace('[u\'', '')
        strImages = strImages.replace('\']', '')
        
        if strType=="thumbnail":
            strImages = strImages+"/"
        else:
            strImages = strImages+"/460"
            
        return strImages
    
def build_a_user_from_obj_qq(obj,accountId):
    result = {}
    result["user_id"]=None
    result["id"]=obj["name"]
    result["account"]=accountId
    result["name"]=obj["nick"]
    result["screen_name"]=obj["name"]
    result["location"]=obj["location"]
    result["profile_image_url"]=toFace(obj["head"])
    
    result["province"]=""
    result["city"]=""
    result["description"]=""
    result["url"]=""
    result["domain"]=""
    result["gender"]=""
    
    result["followers_count"]=0
    result["friends_count"]=0
    result["statuses_count"]=0
    result["favourites_count"]=0
    
    result["created_at"]=toDateTime(obj["timestamp"])
    
    result["following"]=0
    result["verified"]=obj["isvip"]
    
    return result

def toFace(s):
    if s==None or s=="":
        return None
    else:
        return s+"/50"

def toASCII(s):
    lst = []
    for ch in s:
        #hv = hex(ord(ch)).replace('0x', '')
        hv = str(ord(ch))
        #print ch +" -> "+ str(hv)
        lst.append(hv)
   
    return reduce(lambda x,y:x+y, lst)
    
def toDateTime(strTimestamp):
    #ltime=time.localtime(strTimestamp)
    #return time.strftime("%Y-%m-%d %H:%M:%S", ltime)
    return datetime.fromtimestamp(strTimestamp)


def get_last_update_time_by_timeline_type(account,timelineType):
    if timelineType==TIMELINE_TYPE_FRIENDS:
        time=account["last_update_time_friends"]
    elif timelineType==TIMELINE_TYPE_MENTIONS:
        time=account["last_update_time_mentions"]
    elif timelineType==TIMELINE_TYPE_COMMENTS:
        time=account["last_update_time_comments"]
    elif timelineType==TIMELINE_TYPE_DM:
        time=account["last_update_time_dm"]
    elif timelineType==TIMELINE_TYPE_FAVOUR:
        time=account["last_update_time_favour"]
    else:
        time=None
    if time!=None:
        time=str(time).split(".")[0]
    return time

def set_last_update_time_by_timeline_type(account,timelineType,time):
    if timelineType==TIMELINE_TYPE_FRIENDS:
         account["last_update_time_friends"]=time
    elif timelineType==TIMELINE_TYPE_MENTIONS:
         account["last_update_time_mentions"]=time
    elif timelineType==TIMELINE_TYPE_COMMENTS:
         account["last_update_time_comments"]=time
    elif timelineType==TIMELINE_TYPE_DM:
         account["last_update_time_dm"]=time
    elif timelineType==TIMELINE_TYPE_FAVOUR:
         account["last_update_time_favour"]=time
    return account

def cal_status_cell_size(status):
    width=790
    try:
        type=status["type"]
        height=80
        return QSize(width,height)
    except KeyError:
        pass
    minHeight=80
    statusHeight=0
    rtHeight=0
    lineHeight=30
    text=status["text"]
    statusLen= len(text)/2
#    print statusLen
    if status["thumbnail_pic"]!=None:
        statusHeight=(statusLen/26)*lineHeight
        if statusHeight<120:
            statusHeight=120
    else:
        statusHeight=(statusLen/32)*lineHeight
    if statusHeight<40:
        statusHeight=40
    if statusHeight>180:
        statusHeight=180
    rt=status["retweeted_status"]
    rtLen=0
    if rt!=None:
        rtLen=len(status["retweeted_status"]["text"])/2
#        print rtLen
        if rt["thumbnail_pic"]!=None:
            rtHeight=(rtLen/26)*lineHeight
            if rtHeight<120:
                rtHeight=120
        else:
            rtHeight=(rtLen/32)*lineHeight
        if rtHeight<40:
            rtHeight=40
        if rtHeight>180:
            rtHeight=180
    height=minHeight+statusHeight+rtHeight
#    if height<minHeight:
#        height=minHeight
#    print "statusHeight:"+str(statusHeight),"rtHeight:"+str(rtHeight),"height:"+str(height),"width:"+str(width)
    return QSize(width,height)

def gene_datetime_string(timestamp):
    '''Get a human redable string representing the posting time
    Returns:
      A human readable string representing the posting time
    '''
#    fudge = 1.25

    now=datetime.now()
#    print "!!!", now
    dt = datetime.strptime(str(timestamp), "%Y-%m-%d %H:%M:%S")
#    timeString="%s-%s-%s %s:%s" % (dt.year,dt.month,dt.day,dt.hour,dt.minute)
#    sTimeString="%s-%s %s:%s" % (dt.month,dt.day,dt.hour,dt.minute)

    if now.year!=dt.year:
        return "%s-%s-%s %s:%s" % (dt.year,dt.month,dt.day,dt.hour,dt.minute)
    elif now.month!=dt.month:
        return "%s-%s %s:%s" % (dt.month,dt.day,dt.hour,dt.minute)
    elif now.day-dt.day>2:
        return "%s-%s %s:%s" % (dt.month,dt.day,dt.hour,dt.minute)
    elif now.day-dt.day==2:
        return "前天 "+"%s:%s" % (dt.hour,dt.minute)
    elif now.day-dt.day==1:
        return "昨天 "+"%s:%s" % (dt.hour,dt.minute)
    elif now.day==dt.day:
        if now.hour==dt.hour:
            return "%s分钟前" % (now.minute-dt.minute)
        else:
            return "今天 "+"%s:%s" % (dt.hour,dt.minute)
        
    return "%s-%s-%s %s:%s" % (dt.year,dt.month,dt.day,dt.hour,dt.minute)
        

SQL_DROP_ACCOUNT_TABLE="""
DROP TABLE IF EXISTS account;
"""
SQL_DROP_STATUS_TABLE="""
DROP TABLE IF EXISTS status;
"""
SQL_DROP_USER_TABLE="""
DROP TABLE IF EXISTS user;
"""
SQL_DROP_SETTINGS_TABLE="""
DROP TABLE IF EXISTS settings;
"""
SQL_CREATE_ACCOUNT_TABLE="""
CREATE TABLE [account]
(
[id] INTEGER PRIMARY KEY AUTOINCREMENT,
[website] INTEGER,
[nickname] VARCHAR,
[username] VARCHAR,
[password] VARCHAR,
[auto_update] VARCHAR,
[last_update_time_friends] DATETIME,
[last_update_time_mentions] DATETIME,
[last_update_time_comments] DATETIME,
[last_update_time_dm] DATETIME,
[last_update_time_favour] DATETIME
)
"""

SQL_CREATE_STATUS_TABLE="""
CREATE TABLE [status]
(
[id] INTEGER,
[text] VARCHAR,
[source] VARCHAR,
[source_url] VARCHAR,
[favorited] BOOLEAN,
[truncated] BOOLEAN,
[in_reply_to_status_id] INTEGER,
[in_reply_to_user_id] INTEGER,
[in_reply_to_screen_name] VARCHAR,
[thumbnail_pic] VARCHAR,
[bmiddle_pic] VARCHAR,
[original_pic] VARCHAR,
[user] VARCHAR,
[retweeted_status] INTEGER,
[account] INTEGER,
[created_at] DATETIME,
[if_rt] BOOLEAN,
[status_id] INTEGER PRIMARY KEY AUTOINCREMENT,
[author] VARCHAR,
[if_friends] BOOLEAN,
[if_dm] BOOLEAN,
[if_mentions] BOOLEAN,
[if_comments] BOOLEAN,
[if_gap] BOOLEAN,
[cm_num] INTEGER,
[rt_num] INTEGER,
[status] INTEGER,
[reply_comment] INTEGER
)
"""

SQL_CREATE_USER_TABLE="""
CREATE TABLE [user]
(
[id] VARCHAR,
[screen_name] VARCHAR,
[name] VARCHAR,
[province] VARCHAR,
[city] VARCHAR,
[location] VARCHAR,
[description] VARCHAR,
[url] VARCHAR,
[profile_image_url] VARCHAR,
[domain] VARCHAR,
[gender] CHAR,
[followers_count] INTEGER,
[friends_count] INTEGER,
[statuses_count] INTEGER,
[favourites_count] INTEGER,
[created_at] DATETIME,
[following] BOOLEAN,
[verified] BOOLEAN,
[account] INTEGER,
[user_id] INTEGER PRIMARY KEY AUTOINCREMENT
)
"""

SQL_CREATE_SETTINGS_TABLE="""
CREATE TABLE IF NOT EXISTS [settings]
(
[downpic] VARCHAR,
[updatenum] VARCHAR,
[background] VARCHAR,
[updateinterval] VARCHAR,
[notify_led] VARCHAR,
[notify_vibra] VARCHAR,
[notify_sound] VARCHAR,
[updateinterval2] VARCHAR,
[down_orgpic] VARCHAR,
[auto_conn] VARCHAR
)
"""
