# -*- coding: utf-8 -*-


__author__="Michael"
__date__ ="$2010-10-31 23:34:33$"

from DAO import DAO
import logging
import Utils

class Controller():
    def __init__(self):
        self.logger = logging.getLogger('Controller')
        self.dao = DAO()

    def get_all_accounts(self):
        return self.dao.get_all_accounts()

    def get_all_websites(self):
        return self.dao.get_all_websites()

    def save_an_account(self,account):
        if account!=None:
            if account["id"]==None:
                return self.dao.add_an_account(account)
            else:
                return self.dao.update_an_account(account)

    def delete_an_account(self,account):
        self.dao.del_status_by_account(account["id"])
        self.dao.del_an_account(account["id"])

#    def get_status_count_by_account(self,account):
#        r=self.dao.get_status_count_by_account(account,1,0,0,0)
#        return r["count"]
#
#    def get_dm_count_by_account(self,account):
#        r=self.dao.get_status_count_by_account(account,0,1,0,0)
#        return r["count"]
#
#    def get_mentions_count_by_account(self,account):
#        r=self.dao.get_status_count_by_account(account,0,0,1,0)
#        return r["count"]
#
#    def get_comments_count_by_account(self,account):
#        r=self.dao.get_status_count_by_account(account,0,0,0,1)
#        return r["count"]


    def get_statuses_by_account(self, account,timelineType,maxId=None,sinceId=None):
        if_friends=0
        if_dm=0
        if_mentions=0
        if_comments=0
        if timelineType==Utils.TIMELINE_TYPE_FRIENDS:
            if_friends=1
        elif timelineType==Utils.TIMELINE_TYPE_DM:
            if_dm=1
        elif timelineType==Utils.TIMELINE_TYPE_MENTIONS:
            if_mentions=1
        elif timelineType==Utils.TIMELINE_TYPE_COMMENTS:
            if_comments=1

        
        statuses=self.dao.get_statuses_by_account(account,if_friends,if_dm,if_mentions,if_comments,maxId,sinceId)
        for status in statuses:
            self._construct_a_status(account,status)
        return statuses
        
    def get_statuses_by_account_qq(self, account,timelineType,pageflag=0,pagetime=0):
        if_friends=0
        if_dm=0
        if_mentions=0
        if_comments=0
        if timelineType==Utils.TIMELINE_TYPE_FRIENDS:
            if_friends=1
        elif timelineType==Utils.TIMELINE_TYPE_DM:
            if_dm=1
        elif timelineType==Utils.TIMELINE_TYPE_MENTIONS:
            if_mentions=1
        elif timelineType==Utils.TIMELINE_TYPE_COMMENTS:
            if_comments=1

        
        statuses=self.dao.get_statuses_by_account_qq(account,if_friends,if_dm,if_mentions,if_comments,pageflag,pagetime)
        for status in statuses:
            self._construct_a_status(account,status)
        return statuses

    def get_favorited_statuses_by_account(self, account):
        statuses=self.dao.get_favorited_statuses_by_account(account)
        for status in statuses:
            self._construct_a_status(account,status)
        return statuses

    def favour_a_status(self,account,status, favour=1):
        self.dao.favour_a_status(account,status["id"],favour)

    def _construct_a_status(self,account,status):
        userId=status["user"]
        user=self.get_a_user_by_id(account, userId)
        status["user"]=user
        status["author"]=user
        if status["retweeted_status"]!=None:
            rtId=status["retweeted_status"]
            rt=self.dao.get_status_by_account_and_id(account, rtId)
            rtUserId=rt["user"]
            rtUser=self.get_a_user_by_id(account, rtUserId)
            rt["user"]=rtUser
            rt["author"]=rtUser
            status["retweeted_status"]=rt
            
        if status["status"]!=None:
            Id=status["status"]
            #print "_construct_a_status, comment status id :" + str(Id) + " status ID:" + str(status["id"])
            comment_status=self.dao.get_status_by_account_and_id(account, Id)
            self._construct_a_status(account,comment_status)
            status["status"]=comment_status
            #print str(status["status"]["id"]) + " " + status["status"]["text"]
            
        if status["reply_comment"]!=None:
            reply_comment_id=status["reply_comment"]
            #print "_construct_a_status, reply_comment id :" + str(reply_comment_id) + " status ID:" + str(status["id"])
            reply_comment=self.dao.get_status_by_account_and_id(account, reply_comment_id)
            self._construct_a_status(account,reply_comment)
            status["reply_comment"]=reply_comment
            #print str(status["reply_comment"]["id"]) + " " + status["reply_comment"]["text"]
            

    def save_statuses(self,account,statuses,timelineType):
        #print "save_statuses"
        if statuses!=None:
            for status in statuses:
                if timelineType==Utils.TIMELINE_TYPE_FRIENDS:
                    status["if_friends"]=1
                elif timelineType==Utils.TIMELINE_TYPE_DM:
                    status["if_dm"]=1
                elif timelineType==Utils.TIMELINE_TYPE_MENTIONS:
                    status["if_mentions"]=1
                elif timelineType==Utils.TIMELINE_TYPE_COMMENTS:
                    status["if_comments"]=1
                elif timelineType==Utils.TIMELINE_TYPE_FAVOUR:
                    status["favorited"]=1
                    self.save_a_status(account,status)
                    self.dao.favour_a_status(account,status["id"],1)
                    continue
                self.save_a_status(account,status)

    def save_a_status(self,account,status):
        #print "save_a_status :"+status["text"]+str(status["id"])
        self.logger.debug("save_a_status")
        rt=status["retweeted_status"]
        if rt!=None:
            rtUser=rt["user"]
            rtUser=self.save_a_user(rtUser)
            rt["user"]=rtUser["id"]
            rt["author"]=rtUser["id"]
            r=self.dao.get_a_status_by_id(account, rt["id"])
            if r==None:
                self.dao.add_a_status(rt)
            rt["user"]=rtUser
            rt["author"]=rtUser
            status["retweeted_status"]=rt["id"]

        try:
#for commented status
            s=status["status"]
            if s!=None:
                self.save_a_status(account,s)
                status["status"]=s["id"]
                #print "sid:" + str(s["id"])
        except KeyError:
            s=None
            #print "save_a_status commented:"+status["text"]
#for reply_comment status
        try:
            reply_comment=status["reply_comment"]
            if reply_comment!=None:
                self.save_a_status(account,reply_comment)
                status["reply_comment"]=reply_comment["id"]
                #print "reply_comment id:" + str(reply_comment["id"])
        except KeyError:
            reply_comment=None
            #print "save_a_status reply_comment:"+status["text"]
            
        user=status["user"]
        if user!=None:
            self.save_a_user(user)
            status["user"]=user["id"]
            status["author"]=user["id"]
        r=self.dao.get_a_status_by_id(account, status["id"])
        if r==None:
            #print "save_a_status :"+status["text"]
            status=self.dao.add_a_status(status)
            #print "save_status"
            #print status
        else:
            print "r status_id :" + str(r["status_id"])
            status["status_id"] = r["status_id"]

        status["user"]=user
        status["author"]=user
        status["retweeted_status"]=rt
        status["status"]=s
        status["reply_comment"]=reply_comment

    def del_status_by_id(self,account,id):
        self.dao.del_status_by_id(account,id)

    def save_a_user(self,user):
        if user!=None:
            account=user["account"]
            id=user["id"]
            r=self.dao.get_a_user_by_id(account, id)
            if r==None:
                self.dao.add_a_user(user)
            else:
                self.dao.update_a_user(user)
            return user

    def get_a_user_by_id(self,account,id):
        return self.dao.get_a_user_by_id(account, id)


    def save_settings(self,settings):
        if settings!=None:
            return self.dao.save_settings(settings)
            
    def get_settings(self):
        return self.dao.get_settings()
        
    def del_status_by_cache(self):
        self.dao.del_status_by_cache()
        

