# -*- coding: utf-8 -*-

import sqlite3
import Utils
import os
import logging

class DAO():
    def __init__(self):
        self.logger = logging.getLogger('DAO')
        self.logger.debug("connecting to the database")
        self.check_db()
        self.con = sqlite3.connect(Utils.DATA_DB_FILE,check_same_thread=False)
        self.con.text_factory = str
        self.con.row_factory = sqlite3.Row
        self.wcon = sqlite3.connect(Utils.WEBSITE_DB_FILE,check_same_thread=False)
        self.wcon.text_factory = str
        self.wcon.row_factory = sqlite3.Row
        self.logger.debug("connect database completed")

    def check_db(self):
        self.logger.debug("checking db files")
        file=Utils.DATA_DB_FILE
        if os.access(file, os.W_OK) == 0:
            con = sqlite3.connect(file)
            c = con.cursor()
            # Create table
            c.execute(Utils.SQL_DROP_ACCOUNT_TABLE)
            c.execute(Utils.SQL_DROP_STATUS_TABLE)
            c.execute(Utils.SQL_DROP_USER_TABLE)
            c.execute(Utils.SQL_CREATE_ACCOUNT_TABLE)
            c.execute(Utils.SQL_CREATE_STATUS_TABLE)
            c.execute(Utils.SQL_CREATE_USER_TABLE)
            con.commit()
            c.close()
            con.close()

    def get_connection(self):
        return self.con

    def get_w_connection(self):
        return self.wcon

    def get_all_websites(self):
        self.logger.debug('DAO.get_all_websites')
        sql = """
        SELECT * FROM websites
        """
        con = self.get_w_connection()
        c = con.cursor()
        c.execute(sql)
        rs = c.fetchall()
        self.logger.debug(rs)
        c.close()
        return rs

    def get_all_accounts(self):
        self.logger.debug('DAO.get_all_accounts')
        sql = """
        SELECT * FROM account
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql)
        rs = c.fetchall()
        self.logger.debug(rs)
        c.close()
        ss=[]
        for r in rs:
            s=Utils.build_an_account_from_row(r)
            ss.append(s)
        return ss

    def add_an_account(self,account):
        self.logger.debug('DAO.add_an_account')
        self.logger.debug(account)
        sql = """
        INSERT INTO account ("website", "nickname", "username", "password")
          VALUES (:website,:nickname,:username,:password)
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, account)
        con.commit()
        id = c.lastrowid
        account["id"] = id
        self.logger.debug("account id: " + str(id))
        c.close()
        return account

    def update_an_account(self,account):
        self.logger.debug('DAO.update_an_account')
        self.logger.debug(account)
        
        sql = """
        UPDATE account SET website=:website,nickname=:nickname,username=:username,password=:password,
        last_update_time_friends=:last_update_time_friends,
        last_update_time_mentions=:last_update_time_mentions,
        last_update_time_comments=:last_update_time_comments,
        last_update_time_dm=:last_update_time_dm,
        last_update_time_favour=:last_update_time_favour
        WHERE id=:id
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, account)
        con.commit()
        self.logger.debug(c.rowcount)
        c.close()
        return account

    def del_an_account(self,account):
        self.logger.debug('DAO.delete_an_account')
        self.logger.debug("id: " + str(account))
        sql = """
        DELETE FROM account WHERE id=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (account,))
        con.commit()
        c.close()

    def add_a_status(self, status):
        self.logger.debug('DAO.add_a_status')
        self.logger.debug(status)
        sql = """
        INSERT INTO status ("id", "text", "source", "source_url",
          "favorited", "truncated", "in_reply_to_status_id", "in_reply_to_user_id", "in_reply_to_screen_name",
          "thumbnail_pic", "bmiddle_pic", "original_pic", "user","author",
          "retweeted_status","created_at","account","if_rt","if_friends","if_mentions",
          "if_dm","if_comments","if_gap")
          VALUES (:id,:text,:source,:source_url,:favorited,:truncated,:in_reply_to_status_id,
        :in_reply_to_user_id,:in_reply_to_screen_name,:thumbnail_pic,:bmiddle_pic,:original_pic,:user,:author,
        :retweeted_status,:created_at,:account,:if_rt,:if_friends,:if_mentions,:if_dm,:if_comments,:if_gap)
        """
        
        #print "add_a_status:DATA ID------>"+str(status["id"])+" :"
        #print status
        
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, status)
        con.commit()
        id = c.lastrowid
        status["status_id"] = id
        
        #print "add_a_status:SQL ID------>"+str(id)+" :"
        
        self.logger.debug("status id: " + str(id))
        c.close()
        return status

    def get_a_status_by_id(self, account,id):
        self.logger.debug('DAO.get_a_status_by_id')
        self.logger.debug("status id: " + str(id))
        sql = """
        SELECT * FROM status WHERE account=? and id=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (account,id))
        r = c.fetchone()
        c.close()
        self.logger.debug(r)
        user=Utils.build_a_status_from_row(r)
        return user

    def add_a_user(self, user):
        self.logger.debug('DAO.add_a_user')
        self.logger.debug(user)
        sql = """
        INSERT INTO user ("id", "screen_name", "name", "province",
          "city", "location", "description", "url", "profile_image_url",
          "domain", "gender", "followers_count", "friends_count","statuses_count",
          "favourites_count","created_at","following","verified","account")
          VALUES (:id,:screen_name,:name,:province,:city,:location,:description,:url,
        :profile_image_url,:domain,:gender,:followers_count,:friends_count,:statuses_count,
        :favourites_count,:created_at,:following,:verified,:account)
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, user)
        con.commit()
        id = c.lastrowid
        user["user_id"] = id
        self.logger.debug("user_id: " + str(id))
        c.close()
        return user

    def get_a_user_by_id(self, account,id):
        self.logger.debug('DAO.get_a_user_by_id')
        self.logger.debug("user id: " + str(id))
        sql = """
        SELECT * FROM user WHERE account=? and id=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (account,id))
        r = c.fetchone()
        c.close()
        self.logger.debug(r)
        user=Utils.build_a_user_from_row(r)
        return user

    def update_a_user(self,user):
        self.logger.debug('DAO.update_a_user')
        self.logger.debug(user)
        sql = """
        UPDATE user SET screen_name=:screen_name,name=:name,province=:province,city=:city,
        location=:location,description=:description,url=:url,
        profile_image_url=:profile_image_url,domain=:domain,gender=:gender,followers_count=:followers_count,
        friends_count=:friends_count,statuses_count=:statuses_count,
        favourites_count=:favourites_count,created_at=:created_at,following=:following,verified=:verified
        WHERE account=:account and id=:id
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, user)
        con.commit()
        self.logger.debug(c.rowcount)
        c.close()
        return user

    def get_status_count_by_account(self,account,ifFriends,ifDm,ifMentions,ifComments):
        sql = """
        SELECT count(*) as count FROM status WHERE account=? and if_friends=?
        and if_dm=? and if_mentions=? and if_comments=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (account,ifFriends,ifDm,ifMentions,ifComments))
        r = c.fetchone()
        c.close()
        return r


    def get_statuses_by_account(self, account,ifFriends,ifDm,ifMentions,ifComments,maxId=None,sinceId=None, limit=10,offset=0):
        self.logger.debug('DAO.get_statuses_by_account')
        self.logger.debug("account id: " + str(account))
        sql1 = """
        SELECT * FROM status WHERE if_rt=0 and account=? and if_friends=?
        and if_dm=? and if_mentions=? and if_comments=?
        """
        sql2="""
        order by created_at desc limit ? offset ?
        """
        sql=sql1
        if maxId!=None:
            sql+=" and id<"+str(maxId)
        if sinceId!=None:
            sql+=" and id >"+str(sinceId)
        sql+=sql2
        con = self.get_connection()
        c = con.cursor()
        
        c.execute(sql, (account,ifFriends,ifDm,ifMentions,ifComments,limit,offset))
        rs = c.fetchall()
        c.close()
        self.logger.debug(rs)
        ss=[]
        for r in rs:
            s=Utils.build_a_status_from_row(r)
            ss.append(s)
        return ss
        
        
    def get_statuses_by_account_qq(self, account,ifFriends,ifDm,ifMentions,ifComments,pageflag,pagetime, limit=10,offset=0):
        self.logger.debug('DAO.get_statuses_by_account')
        self.logger.debug("account id: " + str(account))
        sql1 = """
        SELECT * FROM status WHERE if_rt=0 and account=? and if_friends=?
        and if_dm=? and if_mentions=? and if_comments=?
        """
        sql2="""
        order by created_at desc limit ? offset ?
        """
        sql=sql1
        if pageflag==1:
            sql+=" and created_at<'"+str(pagetime)+"'"
        if pageflag==2:
            sql+=" and created_at>'"+str(pagetime)+"'"
        sql+=sql2
        con = self.get_connection()
        c = con.cursor()
        
        c.execute(sql, (account,ifFriends,ifDm,ifMentions,ifComments,limit,offset))
        rs = c.fetchall()
        c.close()
        self.logger.debug(rs)
        ss=[]
        for r in rs:
            s=Utils.build_a_status_from_row(r)
            ss.append(s)
        return ss

    def get_favorited_statuses_by_account(self, account):
        self.logger.debug('DAO.get_favorited_statuses_by_account')
        self.logger.debug("account id: " + str(account))
        sql = """
        SELECT * FROM status WHERE favorited=1 and account=? order by id desc
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (account,))
        rs = c.fetchall()
        c.close()
        self.logger.debug(rs)
        ss=[]
        for r in rs:
            s=Utils.build_a_status_from_row(r)
            ss.append(s)
        return ss

    def favour_a_status(self,account,id,favour):
        self.logger.debug('DAO.favour_a_status')
        self.logger.debug("account id: " + str(account)+"status id: " + str(id))
        sql = """
        UPDATE status SET favorited=? WHERE id=? and account=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (favour,id,account))
        con.commit()
        self.logger.debug(c.rowcount)
        c.close()

    def get_status_by_account_and_id(self,account,id):
        self.logger.debug('DAO.get_status_by_account_and_id')
        self.logger.debug("account id: " + str(account))
        self.logger.debug("id: " + str(id))
        sql = """
        SELECT * FROM status WHERE account=? and id=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (account,id))
        r = c.fetchone()
        c.close()
        self.logger.debug(r)
        s=Utils.build_a_status_from_row(r)
        return s

    def del_status_by_id(self,account,id):
        self.logger.debug('DAO.del_status_by_id')
        self.logger.debug("id: " + str(id))
        sql = """
        DELETE FROM status WHERE account=? and id=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (account,id))
        con.commit()
        c.close()

    def del_status_by_account(self,account):
        self.logger.debug('DAO.del_status_by_account')
        self.logger.debug("id: " + str(account))
        sql = """
        DELETE FROM status WHERE account=?
        """
        con = self.get_connection()
        c = con.cursor()
        c.execute(sql, (account,))
        con.commit()
        c.close()


if __name__ == "__main__":
    import sys
    reload(sys)
    sys.setdefaultencoding('utf-8')
#    test_add_a_book()
#    test_get_a_book()
#    test_get_all_books()
#    test_delete_a_book()
#    test_update_a_book()
#    test_add_chapters_for_a_book()
#    test_get_all_chapters_for_a_book()
#    test_update_chapters()
