#include <QApplication>
#include <QVBoxLayout>
#include <QStackedWidget>
#include <QFrame>
#include <QTimer>

#include "mainwindow.h"
#include "netinterfaces.h"
#include "editinterface.h"
#include "processrunner.h"
#include "launcher.h"
#include "passwd.h"
#include "usbmanage.h"

MainWindow::MainWindow(QApplication *parent)
{
	m_app = parent;
	m_mainlayout = new QVBoxLayout;
	m_separator = new QFrame;
	m_runner = new ProcessRunner;

	m_netinterfaces = new NetInterfaces(this, m_runner);
	m_separator->setFrameStyle(QFrame::HLine);
	m_separator->setStyleSheet("background-color: #666");
	m_stack = new QStackedWidget;

	m_mainlayout->addWidget(m_netinterfaces);
	m_mainlayout->addWidget(m_separator);
	m_mainlayout->addWidget(m_stack);

	m_launcher = new Launcher(this);
	m_passwd = new Passwd(this);
	m_usbmanage = new UsbManage(this);
	m_editinterface = new EditInterface(this, m_runner);

	// Note. The order need to be match with enumerator that is used for
	// changing visible widget.
	m_stack->addWidget(m_launcher);
	m_stack->addWidget(m_passwd);
	m_stack->addWidget(m_usbmanage);
	m_stack->addWidget(m_editinterface);

	// reset password when application exits.
	connect(parent, SIGNAL(aboutToQuit()), m_passwd, SLOT(reset()));
	// Usb interface is gone when module is loaded so update interfaces
	connect(m_usbmanage, SIGNAL(done(int)),
		m_netinterfaces, SLOT(updateInterfaces(int)));
	connect(m_netinterfaces, SIGNAL(config_ifaces()),
		m_editinterface, SLOT(configure0()));

	setLayout(m_mainlayout);

	setWindowTitle(tr("Mad Developer"));
}

void
MainWindow::activateLauncher(void)
{
	m_netinterfaces->setEditButtonEnabled(true);
	m_launcher->activateButtons(true);
}

void
MainWindow::showLauncher(void)
{
	m_launcher->activateButtons(false);
	m_stack->setCurrentIndex(LAUNCHER);
	QTimer::singleShot(250, this, SLOT(activateLauncher()));
}

void
MainWindow::showPasswd(void)
{
	m_netinterfaces->setEditButtonEnabled(false);
	m_passwd->generate();
	m_stack->setCurrentIndex(PASSWD);
}

void
MainWindow::showEdit(void)
{
	m_netinterfaces->setEditButtonEnabled(false);
	m_stack->setCurrentIndex(EDIT);
}

void
MainWindow::showUsbManage(void)
{
	m_netinterfaces->setEditButtonEnabled(false);
	m_stack->setCurrentIndex(USB);
}

// Hmm, if help window was child of this this method
// would not have been written...
void
MainWindow::closeEvent(QCloseEvent * event)
{
    (void)event;
    m_app->quit();
}
