#include <QVBoxLayout>
#include <QStackedWidget>
#include <QFrame>

#include "mainwindow.h"
#include "netinterfaces.h"
#include "editinterface.h"
#include "processrunner.h"
#include "launcher.h"
#include "passwd.h"
#include "usbmanage.h"

MainWindow::MainWindow(QObject *parent)
{
	m_mainlayout = new QVBoxLayout;
	m_separator = new QFrame;
	m_runner = new ProcessRunner;

	m_netinterfaces = new NetInterfaces(this, m_runner);
	m_separator->setFrameStyle(QFrame::HLine);
	m_stack = new QStackedWidget;

	m_mainlayout->addWidget(m_netinterfaces);
	m_mainlayout->addWidget(m_separator);
	m_mainlayout->addWidget(m_stack);

	m_launcher = new Launcher(this);
	m_passwd = new Passwd(this);
	m_usbmanage = new UsbManage(this);
	m_editinterface = new EditInterface(this, m_runner);

	// Note. The order need to be match with enumerator that is used for
	// changing visible widget.
	m_stack->addWidget(m_launcher);
	m_stack->addWidget(m_passwd);
	m_stack->addWidget(m_usbmanage);
	m_stack->addWidget(m_editinterface);

	// reset password when application exits.
	connect(parent, SIGNAL(aboutToQuit()), m_passwd, SLOT(reset()));
	// Usb interface is gone when module is loaded so update interfaces
	connect(m_usbmanage, SIGNAL(done()),
		m_netinterfaces, SLOT(updateInterfaces()));

	setLayout(m_mainlayout);

	setWindowTitle(tr("Mad Developer"));
}

void
MainWindow::showLauncher(void)
{
	m_stack->setCurrentIndex(LAUNCHER);
	m_netinterfaces->setEditButtonEnabled(true);
}

void
MainWindow::showPasswd(void)
{
	m_netinterfaces->setEditButtonEnabled(false);
	m_passwd->generate();
	m_stack->setCurrentIndex(PASSWD);
}

void
MainWindow::showEdit(void)
{
	m_stack->setCurrentIndex(EDIT);
}

void
MainWindow::showUsbManage(void)
{
	m_stack->setCurrentIndex(USB);
}
