/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BOOKMARKDLG_H
#define BOOKMARKDLG_H

#include "bookmark.h"

#include <QDialog>

namespace Ui {
    class BookmarkDlg;
}

class BookmarkDlg : public QDialog {
    Q_OBJECT
public:
    BookmarkDlg(QWidget *parent = 0);
    ~BookmarkDlg();

    void setTitle(QString value);
    void setUrl(QString value);
    QString title();
    QString url();

    QPushButton *removeBtt();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::BookmarkDlg *m_pUI;

private slots:
    void on_removeBtt_clicked();
};

#endif // BOOKMARKDLG_H
