/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef WEBPAGE_H
#define WEBPAGE_H

#include <QtWebKit>
#include <QDesktopServices>
// #include <Phonon>

#include "networkcookiejar.h"

class MainWindow;

class WebPage : public QWebPage
{
public:
    WebPage(MainWindow *pMain);

public:
    void saveCookies();
    void setIPhoneUserAgent(bool value=true);
    bool isIphoneUserAgent();

public: // virtual
    QWebPage* createWindow( WebWindowType type );
    /*
    virtual bool extension(Extension extension, const ExtensionOption * option = 0, ExtensionReturn * output = 0 );
    virtual bool supportsExtension ( Extension extension ) const;
    virtual void triggerAction ( WebAction action, bool checked = false );
    */

protected: //virtual
    QString userAgentForUrl(const QUrl &url ) const ;
    bool acceptNavigationRequest( QWebFrame * frame, const QNetworkRequest & request, NavigationType type );

private:
    bool open(const QUrl &url);

#ifdef Q_WS_MAEMO_5
    private:
        bool openWithMediaPlayer(const QUrl &url);
#endif

private:
    bool                m_iphoneUserAgent;
    MainWindow          *m_pMainWindow;
    //NetworkCookieJar*   m_pCookies;
};

#endif // WEBPAGE_H
