/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef VIEWPORTITEM_H
#define VIEWPORTITEM_H

#include <QtGui>
#include <QtWebKit>
#include <QtDebug>

class ViewportItem : public QGraphicsWidget
#ifdef Q_WS_MAEMO_5
        , public QAbstractKineticScroller
#endif
{
    Q_OBJECT

public:
    ViewportItem();

    void setWidget(QGraphicsWidget *widget);

protected:
    bool sceneEventFilter(QGraphicsItem *i, QEvent *e);
    QSize viewportSize() const;
    QPoint maximumScrollPosition() const;
    QPoint scrollPosition() const;
    void setScrollPosition(const QPoint &p, const QPoint &overShoot);
    void cancelLeftMouseButtonPress(const QPoint & /*globalPressPos*/);

public slots:
    void resizeWebViewToFrame();

private:
    QGraphicsWidget *m_widget;
    QPoint m_overShoot;

};

#endif // VIEWPORTITEM_H
