TEMPLATE = app
TARGET = macuco2
SOURCES = main.cpp \
    webview.cpp \
    networkcookiejar.cpp \
    mainwindow.cpp \
    gotodlg.cpp \
    bookmark.cpp \
    bookmarksdlg.cpp \
    bookmarkdlg.cpp \
    webpage.cpp \
    viewportitem.cpp \
    graphicsview.cpp

HEADERS = webview.h \
    webpage.h \
    networkcookiejar.h \
    mainwindow.h \
    fullscreenexitbutton.h \
    gotodlg.h \
    bookmark.h \
    bookmarksdlg.h \
    bookmarkdlg.h \
    viewportitem.h \
    graphicsview.h

OTHER_FILES += macuco2.desktop\
    data/control \
    data/postinst \
    data/64x64/macuco2.png \
    data/40x40/macuco2.png \
    data/26x26/macuco2.png \
    data/maemo/macuco2.xpm \
    macuco2.spec \
    debian/rules \
    debian/README \
    debian/copyright \
    debian/control \
    debian/compat \
    debian/changelog

QT += network \
    webkit

FORMS += \
    gotodlg.ui \
    bookmarksdlg.ui \
    bookmarkdlg.ui

RESOURCES += resources.qrc

maemo5 {
    QT += dbus \
        maemo5

    HEADERS += pickselectoraction.h
    SOURCES += pickselectoraction.cpp
}

unix {

    # VARIABLES
    #isEmpty(PREFIX):PREFIX = debian
    PREFIX = $$INSTALL_ROOT
    BINDIR = $$PREFIX/opt/crochik
    DATADIR = $$PREFIX/usr/share
    DEFINES += DATADIR=\"$$DATADIR\"

    # MAKE INSTALL
    INSTALLS += target \
        desktop \
        # iconxpm \
        icon26 \
        icon40 \
        icon64

    target.path = $$BINDIR
    #target.path = $$PREFIX/$${TARGET}/opt/crochik

    desktop.path = $$DATADIR/applications/hildon
    desktop.files += macuco2.desktop

    #iconxpm.path = $$DATADIR/pixmap
    #iconxpm.files += data/maemo/macuco2.xpm

    icon26.path = $$DATADIR/icons/hicolor/26x26/apps
    icon26.files += data/26x26/macuco2.png

    icon40.path = $$DATADIR/icons/hicolor/40x40/apps
    icon40.files += data/40x40/macuco2.png

    icon64.path = $$DATADIR/icons/hicolor/64x64/apps
    icon64.files += data/64x64/macuco2.png
}
