/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BOOKMARK_H
#define BOOKMARK_H

#include <QtCore>

class Bookmark
{
public:
    Bookmark();
    Bookmark(QString title, QString url);
    ~Bookmark();

public:
    QString title() const;
    QString url() const;
    void setTitle(QString value);
    void setUrl(QString value);

    bool isNull();
    bool operator==(const Bookmark& other);

public:
    static void registerMeataType();

private:
    QString m_url;
    QString m_title;
};

Q_DECLARE_METATYPE(Bookmark)
Q_DECLARE_METATYPE(QList<Bookmark>)

#endif // BOOKMARK_H
