#ifndef WEBPAGE_H
#define WEBPAGE_H

#include <QtWebKit>
#include <QDesktopServices>
// #include <Phonon>

#include "networkcookiejar.h"

class MainWindow;

class WebPage : public QWebPage
{
public:
    WebPage(MainWindow *pMain);

public:
    void saveCookies();
    void setIPhoneUserAgent(bool value=true);
    bool isIphoneUserAgent();

public: // virtual
    QWebPage* createWindow( WebWindowType type );
    /*
    virtual bool extension(Extension extension, const ExtensionOption * option = 0, ExtensionReturn * output = 0 );
    virtual bool supportsExtension ( Extension extension ) const;
    virtual void triggerAction ( WebAction action, bool checked = false );
    */

protected: //virtual
    QString userAgentForUrl(const QUrl &url ) const ;
    bool acceptNavigationRequest( QWebFrame * frame, const QNetworkRequest & request, NavigationType type );

private:
    bool open(const QUrl &url);

#ifdef Q_WS_MAEMO_5
    private:
        bool openWithMediaPlayer(const QUrl &url);
#endif

private:
    bool                m_iphoneUserAgent;
    MainWindow          *m_pMainWindow;
    //NetworkCookieJar*   m_pCookies;
};

#endif // WEBPAGE_H
