#ifndef VIEWPORTITEM_H
#define VIEWPORTITEM_H

#include <QtGui>
#include <QtWebKit>
#include <QtDebug>

class ViewportItem : public QGraphicsWidget
#ifdef Q_WS_MAEMO_5
        , public QAbstractKineticScroller
#endif
{
    Q_OBJECT

public:
    ViewportItem();

    void setWidget(QGraphicsWidget *widget);

protected:
    bool sceneEventFilter(QGraphicsItem *i, QEvent *e);
    QSize viewportSize() const;
    QPoint maximumScrollPosition() const;
    QPoint scrollPosition() const;
    void setScrollPosition(const QPoint &p, const QPoint &overShoot);
    void cancelLeftMouseButtonPress(const QPoint & /*globalPressPos*/);

public slots:
    void resizeWebViewToFrame();

private:
    QGraphicsWidget *m_widget;
    QPoint m_overShoot;

};

#endif // VIEWPORTITEM_H
