#include "graphicsview.h"

#include "viewportitem.h"

GraphicsView::GraphicsView(QWidget *pParent)
    : QGraphicsView(new QGraphicsScene(), pParent)
{
    viewport = new ViewportItem();

    setViewportUpdateMode(QGraphicsView::BoundingRectViewportUpdate);
    setOptimizationFlags(QGraphicsView::DontSavePainterState);

    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    setFrameShape(QFrame::NoFrame);
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    scene()->addItem(viewport);
}

ViewportItem *GraphicsView::viewportItem() const {
    return viewport;
}

void GraphicsView::resizeEvent(QResizeEvent *e) {
    QGraphicsView::resizeEvent(e);

    if (!viewport) return;

    QRectF rect(QPointF(0, 0), size());

    setUpdatesEnabled(false);
    scene()->setSceneRect(rect);
    viewport->setGeometry(rect);
    setUpdatesEnabled(true);

    update();
}

