#ifndef BOOKMARKSDLG_H
#define BOOKMARKSDLG_H

#include <QDialog>
#include <QListWidgetItem>

#include "bookmark.h"

namespace Ui {
    class BookmarksDlg;
}

class BookmarksDlg : public QDialog {
    Q_OBJECT
public:
    BookmarksDlg(QList<Bookmark>& list, QWidget *parent = 0);
    ~BookmarksDlg();

protected:
    void changeEvent(QEvent *e);

private:
    void loadItems();

public:
    Bookmark            m_bookmark;

private:
    Ui::BookmarksDlg    *m_pUI;
    QList<Bookmark>&    m_bookmarks;
    QListWidgetItem     *m_pItem;

private slots:
    void on_listWidget_customContextMenuRequested(QPoint pos);
    void on_listWidget_itemDoubleClicked(QListWidgetItem* item);
    void on_listWidget_itemClicked(QListWidgetItem* item);

    void onRemoveBookmark();
};

#endif // BOOKMARKSDLG_H
