#include "bookmarkdlg.h"
#include "ui_bookmarkdlg.h"

BookmarkDlg::BookmarkDlg(QWidget *parent) :
    QDialog(parent),
    m_pUI(new Ui::BookmarkDlg)
{
    m_pUI->setupUi(this);
}

BookmarkDlg::~BookmarkDlg()
{
    delete m_pUI;
}

void BookmarkDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        m_pUI->retranslateUi(this);
        break;
    default:
        break;
    }
}

void BookmarkDlg::setTitle(QString value){
    return m_pUI->titleEdit->setText(value);
}

void BookmarkDlg::setUrl(QString value) {
    return m_pUI->urlEdit->setText(value);
}

QString BookmarkDlg::title(){
    return m_pUI->titleEdit->text();
}

QString BookmarkDlg::url() {
    return m_pUI->urlEdit->text();
}

QPushButton* BookmarkDlg::removeBtt() {
    return m_pUI->removeBtt;
}

void BookmarkDlg::on_removeBtt_clicked()
{
    // ...
    reject();
}
