#include "application.h"

#ifdef Q_WS_MAEMO_5
    #include <QDBusConnection>

    #include "macucodbusadptr.h"
#endif

#include <QDebug>

#include "webviewwindow.h"
#include "graphicsviewwindow.h"
#include "bookmark.h"

#define CURRENT_APP_VERSION 14
#define APPFOLDER "/home/user/.macuco/"
#ifndef QT_NO_DEBUG_OUTPUT
    #define LOGFILE "/home/user/.macuco/log.txt"
#endif

void logMessageHandler(QtMsgType type, const char *msg)
{
    QString txt;
    switch (type) {
        case QtDebugMsg:
            txt = QString("(DBG) %1").arg(msg);
            break;

        case QtWarningMsg:
            txt = QString("(WRN) %1").arg(msg);
            break;

        case QtCriticalMsg:
            txt = QString("(CRT) %1").arg(msg);
            break;

        case QtFatalMsg:
            txt = QString("(FAT) %1").arg(msg);
            break;
    }

    QFile outFile(LOGFILE);
    outFile.open(QIODevice::WriteOnly | QIODevice::Append);
    QTextStream ts(&outFile);
    ts << txt << endl;
    outFile.close();

    if ( type==QtFatalMsg ) abort();
}

Application::Application(int & argc, char ** argv) :
    QApplication(argc,argv),
    m_pMainWindow(NULL)
{
#ifdef Q_WS_MAEMO_5
    new MacucoDBusAdptr(this);
#endif

    setOrganizationName("Crochik");
    setApplicationName("Macuco");
}

Application::~Application() {
    qDebug() << "delete MainWindow";
    delete m_pMainWindow; m_pMainWindow = NULL;
}

int Application::execute() {

#ifdef Q_WS_MAEMO_5
    if ( !registerService() ) {
        qWarning() << "There is one instance running already.";
        /*
        QUrl url(arguments().last());
        if ( url.isValid() ) {
            qDebug() << ">> url on command line: send dbus signal to 'main instance'";
            // ...
        }
        */
        qWarning() << ">> exiting this instance";
        return 0;
    }
#endif

#ifdef LOGFILE
    bool skipLog = false;
    foreach ( QString arg, arguments() ) {
        if ( arg=="--nolog" ) {
            qDebug() << "Do not install log handler.";
            skipLog = true;
        }
    }

    if  (!skipLog) {
        // delete previous log
        if ( QFile::exists(LOGFILE) ) {
            if ( !QFile::remove(LOGFILE) ) {
                qCritical() << "Failed to remove log file... it will keep adding to previous one";
            }
        }
        qDebug() << "Redirect output to log file: " << LOGFILE;
        qInstallMsgHandler(logMessageHandler);
    }
#endif

    loadSettings();

#ifndef Q_WS_MAEMO_5
    start();
#endif

    int res = exec();

    saveSettings();

    return res;
}

MainWindow* Application::newWindow() {

#ifdef Q_WS_MAEMO_5
    // GraphicsViewWindow *pMainWindow = new GraphicsViewWindow(m_pMainWindow);
    WebViewWindow *pMainWindow = new WebViewWindow(m_pMainWindow);
#else
    WebViewWindow *pMainWindow = new WebViewWindow(m_pMainWindow);
#endif

    if ( m_pMainWindow ) {
        pMainWindow->setAttribute(Qt::WA_DeleteOnClose);
    } else {
        m_pMainWindow = pMainWindow;
    }

    return pMainWindow;
}

#ifdef Q_WS_MAEMO_5
bool Application::registerService() {
    QDBusConnection connection = QDBusConnection::sessionBus();
    if ( !connection.registerService("com.crochik.Macuco") ) {
        qDebug() << "error registering service.";
        return false;
    }

    if ( !connection.registerObject("/", this) ) {
        qDebug() << "error registering object";
        return false;
    }

    qDebug() << "D-Bus service successfully registered";

    return true;
}
#endif

void Application::start() {
    qDebug() << "DBus signal:start";
    if ( m_pMainWindow && !m_pMainWindow->isVisible()) {
        qDebug() << ">> reuse main window";
        m_pMainWindow->show();
        m_pMainWindow->activateWindow();
        m_pMainWindow->raise();
        return;
    }

    visitUrl(QString::null, m_fakeUserAgent);
}

void Application::open(const QString &url, bool fakeAgent) {
    qDebug() << "DBus signal:open " << url << ", " << fakeAgent;
    visitUrl(url, fakeAgent);
}

void Application::visitUrl(QString url, bool fakeAgent) {
    MainWindow *pWindow = NULL;

    if ( m_pMainWindow && !m_pMainWindow->isVisible()) {
        qDebug() << ">> reuse main window: " << url;
        pWindow = m_pMainWindow;
    } else {
        qDebug() << ">> create new window: " << url;
        pWindow = newWindow();
    }

    pWindow->showFullScreen();
    pWindow->setUserAgent(fakeAgent);
    if ( url.isEmpty() ) pWindow->goHome(); else pWindow->visitUrl(url);
    pWindow->raise();
}

void Application::loadSettings() {
    qDebug() << "load settings";
    qDebug() << "Version: " << QString::number(CURRENT_APP_VERSION);

    Bookmark::registerMeataType();

    QSettings settings("Macuco", "Macuco");
    int version = settings.value("version", 0).toInt();
    m_bookmarks = settings.value("bookmarks").value< QList<Bookmark> >();
    // m_fullScreen = settings.value("fullScreen", false).toBool();
    m_fakeUserAgent = settings.value("iphoneUserAgent", true).toBool();
    m_orientation = settings.value("orientation", 0).toInt();

#ifdef Q_WS_MAEMO_5
    // v27
    bool keepRunning = settings.value("keepRunning", true).toBool();
    qDebug() << "keep running in the background: " << keepRunning;
    QApplication::setQuitOnLastWindowClosed(!keepRunning);
#endif

    qDebug() << "try to get icons";
    // get page icons
    // (work around for not getting the icons the first time - have to investigate)
    for ( int c=0; c<m_bookmarks.size(); c++ ) {
        QWebSettings::iconForUrl(m_bookmarks[c].url());
    }

    qDebug() << ">> done loading settings";

    if ( version<CURRENT_APP_VERSION ) {
        qDebug() << "Upgrading from " + QString::number(version) + " to " + QString::number(CURRENT_APP_VERSION);
        aboutMacuco();
    }
}

void Application::saveSettings() {
    QSettings settings("Macuco", "Macuco");
    settings.setValue("version", CURRENT_APP_VERSION);
    // settings.setValue("fullScreen", m_fullScreen);
    settings.setValue("iphoneUserAgent", m_fakeUserAgent);
    settings.setValue("orientation", m_orientation);

    QVariant bookmarks;
    bookmarks.setValue(m_bookmarks);
    settings.setValue("bookmarks", bookmarks);
}

void Application::aboutMacuco() {
    visitUrl(QString("http://www.crochik.com/macuco2/about%1.html").arg(QString::number(CURRENT_APP_VERSION)), true);
}
