/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "graphicsview.h"

#include "viewportitem.h"

GraphicsView::GraphicsView(QWidget *pParent)
    : QGraphicsView(new QGraphicsScene(), pParent)
{
    viewport = new ViewportItem();

    setViewportUpdateMode(QGraphicsView::BoundingRectViewportUpdate);
    setOptimizationFlags(QGraphicsView::DontSavePainterState);

    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    setFrameShape(QFrame::NoFrame);
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    scene()->addItem(viewport);
}

ViewportItem *GraphicsView::viewportItem() const {
    return viewport;
}

void GraphicsView::resizeEvent(QResizeEvent *e) {
    QGraphicsView::resizeEvent(e);

    if (!viewport) return;

    QRectF rect(QPointF(0, 0), size());

    qDebug() << "QGraphicsView::resizeEvent " << rect;

    setUpdatesEnabled(false);
    // scene()->setSceneRect(rect); // ????
    viewport->setGeometry(rect);
    setUpdatesEnabled(true);

    update();
}

