#include "application.h"

#include <QDBusConnection>
#include <QDebug>

#include "macucodbusadptr.h"
#include "webviewwindow.h"
#include "graphicsviewwindow.h"

#define APPFOLDER "/home/user/.macuco/"
#ifndef QT_NO_DEBUG_OUTPUT
    #define LOGFILE "/home/user/.macuco/log.txt"
#endif

void logMessageHandler(QtMsgType type, const char *msg)
{
    QString txt;
    switch (type) {
        case QtDebugMsg:
            txt = QString("(DBG) %1").arg(msg);
            break;

        case QtWarningMsg:
            txt = QString("(WRN) %1").arg(msg);
            break;

        case QtCriticalMsg:
            txt = QString("(CRT) %1").arg(msg);
            break;

        case QtFatalMsg:
            txt = QString("(FAT) %1").arg(msg);
            break;
    }

    QFile outFile(LOGFILE);
    outFile.open(QIODevice::WriteOnly | QIODevice::Append);
    QTextStream ts(&outFile);
    ts << txt << endl;
    outFile.close();

    if ( type==QtFatalMsg ) abort();
}

Application::Application(int & argc, char ** argv) :
    QApplication(argc,argv),
    m_pMainWindow(NULL)
{
    new MacucoDBusAdptr(this);
}

Application::~Application() {
    qDebug() << "delete MainWindow";
    delete m_pMainWindow; m_pMainWindow = NULL;
}

int Application::execute() {

    if ( !registerService() ) {
        qWarning() << "There is one instance running already.";
        /*
        QUrl url(arguments().last());
        if ( url.isValid() ) {
            qDebug() << ">> url on command line: send dbus signal to 'main instance'";
            // ...
        }
        */
        qWarning() << ">> exiting this instance";
        return 0;
    }

#ifdef LOGFILE
    bool skipLog = false;
    foreach ( QString arg, arguments() ) {
        if ( arg=="--nolog" ) {
            qDebug() << "Do not install log handler.";
            skipLog = true;
        }
    }

    if  (!skipLog) {
        // delete previous log
        if ( QFile::exists(LOGFILE) ) {
            if ( !QFile::remove(LOGFILE) ) {
                qCritical() << "Failed to remove log file... it will keep adding to previous one";
            }
        }
        qDebug() << "Redirect output to log file: " << LOGFILE;
        qInstallMsgHandler(logMessageHandler);
    }
#endif

    // show main window
    m_pMainWindow = newWindow();
    m_pMainWindow->show();

    /*
    QUrl url(arguments().last());
    if ( url.isValid() ) {
        qDebug() << ">> url on command line: start new window";
        MainWindow *pWindow = newWindow();
        pWindow->visitUrl(arguments().last());
        pWindow->raise();
    }
    */

    return exec();
}

MainWindow* Application::newWindow() {

#ifdef Q_WS_MAEMO_5
    // GraphicsViewWindow *pMainWindow = new GraphicsViewWindow(m_pMainWindow);
    WebViewWindow *pMainWindow = new WebViewWindow(m_pMainWindow);
#else
    WebViewWindow *pMainWindow = new WebViewWindow(m_pMainWindow);
#endif

    if ( m_pMainWindow ) pMainWindow->setAttribute(Qt::WA_DeleteOnClose);

    return pMainWindow;
}

bool Application::registerService() {
    QDBusConnection connection = QDBusConnection::sessionBus();
    if ( !connection.registerService("com.crochik.Macuco") ) {
        qDebug() << "error registering service.";
        return false;
    }

    if ( !connection.registerObject("/", this) ) {
        qDebug() << "error registering object";
        return false;
    }

    qDebug() << "D-Bus service successfully registered";

    return true;
}

void Application::open(const QString &url, bool fakeAgent) {
    qDebug() << "DBus signal:open " << url << ", " << fakeAgent;
    visitUrl(url, fakeAgent);
}

void Application::visitUrl(QString url, bool fakeAgent) {
    Q_ASSERT(m_pMainWindow);

    // create new window
    qDebug() << ">> create new window: " << url;
    MainWindow *pWindow = newWindow();
    pWindow->showFullScreen();
    pWindow->setUserAgent(fakeAgent);
    pWindow->visitUrl(url);
    pWindow->raise();
}
