#include "webviewwindow.h"
#include "qwebviewselectionsuppressor.h"

WebViewWindow::WebViewWindow(MainWindow *pParent) :
    MainWindow(pParent)
{
    m_pWebView = NULL;

    // using web view
    m_pWebView = new QWebView(this);

    connect(m_pWebView, SIGNAL(loadStarted()), this, SLOT(showLoading()));
    connect(m_pWebView, SIGNAL(urlChanged(QUrl)), this, SLOT(changeUrl(QUrl)));
    connect(m_pWebView, SIGNAL(loadFinished(bool)), this, SLOT(hideLoading(bool)));

#ifdef Q_WS_MAEMO_5
    m_webPage.mainFrame()->setScrollBarPolicy(Qt::Vertical, Qt::ScrollBarAlwaysOff);
    m_webPage.mainFrame()->setScrollBarPolicy(Qt::Horizontal, Qt::ScrollBarAlwaysOff);

    new QWebViewSelectionSuppressor(m_pWebView);
#endif

    m_pWebView->setPage(&m_webPage);
    setCentralWidget(m_pWebView);

    startUp();
}

void WebViewWindow::onScroll(const QPoint &offset) {
    qDebug() <<"scroll: " << offset;
    QWebFrame *frame = m_webPage.mainFrame();
    if (!frame) {
        qDebug() << "frame not found?!?!";
        return;
    }

    qDebug() << "Scroll To: " << offset.x() << ", " << offset.y();
    frame->evaluateJavaScript(QString("window.scrollBy(%1,%2);").arg(-offset.x()).arg(-offset.y()));
}

void WebViewWindow::updateTitle() {
#ifndef Q_WS_MAEMO_5
    QString title = m_currentUrl.isEmpty() || !m_pWebView ? "Macuco" : m_pWebView->title();
    if ( m_webPage.isIphoneUserAgent() ) title += " - iPhone";
    title += QString(" - %1%").arg(QString::number(m_zoomFactor*100, 'f', 0));

    setWindowTitle(title);
#endif

}

MainWindow* WebViewWindow::createWindow() {
    if ( m_pParent ) return m_pParent->createWindow();

    // top most
    return new WebViewWindow(this);
}

void WebViewWindow::visitUrl(QUrl url) {
    Q_ASSERT(m_pWebView);
    m_pWebView->load(url);
}

void WebViewWindow::setZoom(qreal zoomFactor) {
    MainWindow::setZoom(zoomFactor);

    Q_ASSERT(m_pWebView);
    if ( !m_pWebView ) return;
    m_pWebView->setZoomFactor(m_zoomFactor);
}
