/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QLabel>

#ifdef Q_WS_X11 // meego?
    // ????
#endif

#ifdef Q_WS_MAEMO_5
    #include "pickselectoraction.h"
#endif

#include "bookmark.h"
#include "webpage.h"


namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT

public:
    explicit MainWindow(MainWindow *pParent);
    virtual ~MainWindow();

    void adjustSizes(); //manually adapt layout to new size
    void keyPressEvent(QKeyEvent *event);

    QWebPage *page() { return &m_webPage; }
    MainWindow *topMost();

    void visitUrl(QString);
    void setUserAgent(bool iphone=true);

public:
    virtual MainWindow *createWindow() =0;

protected:
    virtual void updateTitle()=0;
    virtual void visitUrl(QUrl)=0;
    virtual void setZoom(qreal zoomFactor);

protected:
    void startUp();
    void loadSettings();
    void saveSettings();

    bool isFullScreen();

    // reimplement resize event to adapt layout
    void resizeEvent(QResizeEvent* event);

    //intercepts close event
    void closeEvent(QCloseEvent *event);

    void zoomIn();
    void zoomOut();
    void zoomFit();
    void createMenu();
    bool setViewport();

    void enableWebkitAutoSize();

#ifdef Q_WS_MAEMO_5
    void grabZoomKeys(bool grab);
    bool isLandscape();
    bool isAutoRotate();
    void setLandscape(bool landscape=true);
    void setAutoRotate(bool autoRotate=true);
#endif

protected slots:
    void on_actionUser_Agent_triggered();
    void on_actionAdd_Bookmark_triggered();
    void on_actionGo_To_triggered();
    void on_actionAuto_Rotate_triggered();
    void on_actionLandscape_triggered();
    void on_actionBookmarks_triggered();
    void on_actionHome_triggered();

    void onUserAgentChanged(QAction *pAction);

    void aboutQt();
    // void switchView();
    void setFullScreen(bool full=true);
    void showLoading(); //called when a "loading page" is started
    void changeUrl(QUrl url); //called when the url is changed. The url will be used on the retry action
    void hideLoading(bool success); //called when a "loading page" is finished
    void reload(); //reload the page

    void finishedRequest(QNetworkReply* reply); //request

    // QWebView/QWebPage
    void linkClicked ( const QUrl & url );
    void unsupportedContent(QNetworkReply*);
    void downloadRequested (const QNetworkRequest& request);

    void userAgent_selectionChanged(int index);
    void orientation_selectionChanged(int index);

#ifdef Q_WS_MAEMO_5
    void orientationChanged();
    void fullscreen_triggered();
#endif

protected:
    // mainWindow components
    QUrl            m_currentUrl;
    qreal           m_zoomFactor;
    QStringList     m_errors;

    QList<Bookmark> *m_pBookmarks;
    WebPage         m_webPage;
    MainWindow      *m_pParent;

#ifdef Q_WS_MAEMO_5
    PickSelectorAction  *m_pUserAgentSelector;
    PickSelectorAction  *m_pOrientationSelector;
#endif

};

#endif // MAINWINDOW_H
