/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BOOKMARKSDLG_H
#define BOOKMARKSDLG_H

#include <QDialog>
#include <QListWidgetItem>

#include "bookmark.h"

namespace Ui {
    class BookmarksDlg;
}

class BookmarksDlg : public QDialog {
    Q_OBJECT
public:
    BookmarksDlg(QList<Bookmark>& list, QWidget *parent = 0);
    ~BookmarksDlg();

protected:
    void changeEvent(QEvent *e);

private:
    void loadItems();

public:
    Bookmark            m_bookmark;

private:
    Ui::BookmarksDlg    *m_pUI;
    QList<Bookmark>&    m_bookmarks;
    QListWidgetItem     *m_pItem;

private slots:
    void on_listWidget_customContextMenuRequested(QPoint pos);
    void on_listWidget_itemDoubleClicked(QListWidgetItem* item);
    void on_listWidget_itemClicked(QListWidgetItem* item);

    void onRemoveBookmark();
};

#endif // BOOKMARKSDLG_H
