/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "webpage.h"

#include <QtWebKit>
#include <QDesktopServices>
// #include <Phonon>

#include "QtWebKit"

#ifdef Q_WS_MAEMO_5
    // #include "hildon-mime.h"
    #include <QDBusMessage>
    #include <QDBusConnection>
#endif

#include "mainwindow.h"

WebPage::WebPage(MainWindow *pMain) {
    m_pMainWindow = pMain;
    m_iphoneUserAgent = true;

    // network access manager will assume ownership of m_pCookies: no need to delete
    networkAccessManager()->setCookieJar(new NetworkCookieJar);

    setForwardUnsupportedContent (true);
}

QWebPage* WebPage::createWindow( WebWindowType type ) {
    Q_ASSERT(m_pMainWindow);
    MainWindow *pWnd = m_pMainWindow->createWindow();
    return pWnd->page();
}

void WebPage::saveCookies() {
    NetworkCookieJar *pCookies = (NetworkCookieJar *)networkAccessManager()->cookieJar();
    pCookies->saveCookies();
}

void WebPage::setIPhoneUserAgent(bool value/*=true*/) {
    m_iphoneUserAgent = value;
}

bool WebPage::isIphoneUserAgent() {
    return m_iphoneUserAgent;
}

QString WebPage::userAgentForUrl(const QUrl &url ) const{
    if ( !m_iphoneUserAgent ) return QWebPage::userAgentForUrl(url);

    // Mozilla/5.0 (iPad; U; CPU iPhone OS 3_2 like Mac OS X; en-us) AppleWebKit/531.21.10 (KHTML, like Gecko) Version/4.0.4 Mobile/7B314 Safari/531.21.10

    Q_UNUSED(url);
    return QString("Mozilla/5.0 (iPhone; U; CPU iPhone OS 3_1 like Mac OS X; en-us) AppleWebKit/528.18 (KHTML, like Gecko) Version/4.0 Mobile/7C97d Safari/528.16");
    //return QString("Mozilla/5.0 (iPad; U; CPU iPhone OS 3_2 like Mac OS X; en-us) AppleWebKit/531.21.10 (KHTML, like Gecko) Version/4.0.4 Mobile/7B314 Safari/531.21.10");
}

bool WebPage::acceptNavigationRequest( QWebFrame * frame, const QNetworkRequest & request, NavigationType type )  {
    /*
    QList<QByteArray> headerList = request.rawHeaderList();
    qDebug() << "acceptNavigationRequest: "
            << type
            << request.url()
            << request.header(QNetworkRequest::ContentTypeHeader);

    foreach ( QByteArray array, headerList ) {
        QString header(array);
        QString value(request.rawHeader(array));
        qDebug() << "Header: " << header << value;
    }

    // QNetworkReply *pReply = networkAccessManager()->get(request);
    GetHeadThread thread(*networkAccessManager(), request);
    thread.start();
    thread.wait(10000);

    headerList = pReply->rawHeaderList();
    QString mimeType = pReply->header(QNetworkRequest::ContentTypeHeader).toString();
    qDebug() << "mime type: " << mimeType;
    foreach ( QByteArray array, headerList ) {
        QString header(array);
        QString value(request.rawHeader(array));
        qDebug() << "Header: " << header << value;
    }

    delete pReply;
    */

    QString urlStr = request.url().toString();
    int index = urlStr.lastIndexOf('.');
    if ( index>0 ) {
        urlStr = urlStr.mid(index).toLower();
        if ( QString(".mp3.mp4").indexOf(urlStr)>=0 ) {
            open(request.url());
            return false;
        }
    }

    return QWebPage::acceptNavigationRequest(frame, request, type);
}

bool WebPage::open(const QUrl &url) {
#ifdef Q_WS_MAEMO_5
    return openWithMediaPlayer(url);
#else
    return QDesktopServices::openUrl(url);
#endif
}

#ifdef Q_WS_MAEMO_5
bool WebPage::openWithMediaPlayer(const QUrl &url) {
    // defaults.list
    // = hildon-mediaplayer.desktop:X-Osso-URI-Action-Open

    // mediaplayer.desktop
    // = Exec: /usr/bin/mediaplayer
    // = MimeType: video/mp4, video/x-mp4, ...
    // = X-Osso-Service: mediaplayer
    // = Method: mime_open
    // = Name: uri_link_play
    // = TRansloationDomain: osso-uri
    // = service: com.nokia.mediaplayer
    // = method: mime_open

    // dbus-send
    // * dest: com.nokia.mediaplayer
    // * destination obj path: /com/nokia/mediaplayer
    // * message name: com.nokia.mediaplayer.mime_open
    // * contents: string:"file:///$1"
    QDBusMessage msg = QDBusMessage::createMethodCall(
        "com.nokia.mediaplayer",
        "/com/nokia/mediaplayer", // "/" also works
        "com.nokia.mediaplayer",
        "mime_open"
    );
    msg << url.toString();
    QDBusMessage ret = QDBusConnection::sessionBus().call(msg);
    return ret.type() != QDBusMessage::ErrorMessage;
}
#endif

/*
    Phonon::VideoPlayer *player = new Phonon::VideoPlayer(Phonon::VideoCategory, this->view());
    connect(player, SIGNAL(finished()), player, SLOT(deleteLater()));
    player->play(request.url());
*/


/*
virtual bool extension(Extension extension, const ExtensionOption * option = 0, ExtensionReturn * output = 0 ) {
    qDebug() << "extension: " << extension;
    return QWebPage::extension(extension, option, output);
}

virtual bool supportsExtension ( Extension extension ) const {
    qDebug() << "supportsExtension: " << extension;
    return QWebPage::supportsExtension(extension);
}

virtual void triggerAction ( WebAction action, bool checked = false ) {
    qDebug() << "triggerAction: " << action;

    QWebPage::triggerAction(action,checked);

}
*/
