/*
 * Copyright 2010 Felipe Crochik <foss@crochik.com>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "gotodlg.h"
#include "ui_gotodlg.h"

GoToDlg::GoToDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::GoToDlg)
{
    ui->setupUi(this);
}

GoToDlg::~GoToDlg()
{
    delete ui;
}

void GoToDlg::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

QString GoToDlg::url() {
    return ui->urlEdit->text();
}


void GoToDlg::setUrl(QString url) {
    ui->urlEdit->setText(url);
    ui->urlEdit->selectAll();
}
