#ifndef WEBVIEW_H
#define WEBVIEW_H

#include <QtWebKit>
#include <QtGui>
#include <QTime>

#include "webpage.h"

class FlickableTicker;

class WebView : public QWebView
{
    Q_OBJECT

public:
    typedef enum {
        Steady,
        Pressed,
        ManualScroll,
        AutoScroll,
        Stop,
        Bug
    } State;

public:
    friend class FlickableTicker;
    WebView(QWidget *parent = 0);

    void setScrollOffset(const QPoint &offset);
    QPoint scrollOffset() const;

protected:
    void keyReleaseEvent(QKeyEvent *event);
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

    QWebView* createWindow ( QWebPage::WebWindowType type );

private:
    void tick();

private:
    State m_state;
    int m_threshold;
    QPoint m_pressPos;
    QPoint m_offset;
    QPoint m_delta;
    QPoint m_speed;
    FlickableTicker *m_pTicker;
    QTime m_timeStamp;
    QList<QEvent*> m_ignoreList;
};

#endif // WEBVIEW_H
