#include "webgraphicsview.h"
#include "viewportitem.h"

WebGraphicsView::WebGraphicsView()
    : QGraphicsView(new QGraphicsScene()), viewport(0)
{
    setViewportUpdateMode(QGraphicsView::BoundingRectViewportUpdate);
    setOptimizationFlags(QGraphicsView::DontSavePainterState);

    setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
    setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    setFrameShape(QFrame::NoFrame);
    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);

    viewport = new ViewportItem();
    scene()->addItem(viewport);
}

ViewportItem *WebGraphicsView::viewportItem() const
{
    return viewport;
}

void WebGraphicsView::resizeEvent(QResizeEvent *e)
{
    QGraphicsView::resizeEvent(e);
    setUpdatesEnabled(false);

    if (!viewport)return;

    QRectF rect(QPointF(0, 0), size());
    scene()->setSceneRect(rect);

    viewport->setGeometry(rect);
    setUpdatesEnabled(true);
    update();
}

