#ifndef WEBPAGE_H
#define WEBPAGE_H

#include <QtWebKit>
#include <QDesktopServices>
// #include <Phonon>

#include "networkcookiejar.h"

class WebPage : public QWebPage
{
public:
    WebPage();

public:
    void saveCookies();
    void setIPhoneUserAgent(bool value=true);
    bool isIphoneUserAgent();

    bool acceptNavigationRequest( QWebFrame * frame, const QNetworkRequest & request, NavigationType type );

    virtual QString userAgentForUrl(const QUrl &url ) const ;

    /*
    virtual bool extension(Extension extension, const ExtensionOption * option = 0, ExtensionReturn * output = 0 );
    virtual bool supportsExtension ( Extension extension ) const;
    virtual void triggerAction ( WebAction action, bool checked = false );
    */

private:
    bool open(const QUrl &url);

#ifdef Q_WS_MAEMO_5
    private:
        bool openWithMediaPlayer(const QUrl &url);
#endif


private:
    bool                m_iphoneUserAgent;
    //NetworkCookieJar*   m_pCookies;
};

#endif // WEBPAGE_H
