#ifndef BOOKMARK_H
#define BOOKMARK_H

#include <QtCore>

class Bookmark
{
public:
    Bookmark();
    Bookmark(QString title, QString url);
    ~Bookmark();

public:
    QString title() const;
    QString url() const;
    void setTitle(QString value);
    void setUrl(QString value);

    bool isNull();
    bool operator==(const Bookmark& other);

public:
    static void registerMeataType();

private:
    QString m_url;
    QString m_title;
};

Q_DECLARE_METATYPE(Bookmark)
Q_DECLARE_METATYPE(QList<Bookmark>)

#endif // BOOKMARK_H
