#include "webview.h"
#include "mainwindow.h"

WebView::WebView(QWidget *parent)
        : QWebView(parent)
{
    setAttribute(Qt::WA_OpaquePaintEvent, true);
    setAttribute(Qt::WA_NoSystemBackground, true);

    setMouseTracking(true);
    Flickable::setAcceptMouseClick(this);
}

// reimplement from Flickable
QPoint WebView::scrollOffset() const {
    QWebFrame *frame = page()->mainFrame();

    int x = frame->evaluateJavaScript("window.scrollX").toInt();
    int y = frame->evaluateJavaScript("window.scrollY").toInt();
    qDebug() << "Current Scroll Offset: " << x << ", " << y;

    return QPoint(x, y);
}

// reimplement from Flickable
void WebView::setScrollOffset(const QPoint &offset) {
    QWebFrame *frame = page()->mainFrame();
    if (!frame) {
        qDebug() << "frame not found?!?!";
        return;
    }

    qDebug() << "Scroll To: " << offset.x() << ", " << offset.y();
    frame->evaluateJavaScript(QString("window.scrollTo(%1,%2);").arg(offset.x()).arg(offset.y()));
}

void WebView::keyReleaseEvent(QKeyEvent *event) {
    if (event->key() == Qt::Key_Down) {
        setScrollOffset( QPoint(0, scrollOffset().y() + 20) );
        return;
    }

    if (event->key() == Qt::Key_Up) {
        int y = scrollOffset().y();
        y = (y-20>0) ? y-20 :0;
        setScrollOffset( QPoint(0, y) );
        return;
    }
}

void WebView::mousePressEvent(QMouseEvent *event) {
    Flickable::handleMousePress(event);
    if (event->isAccepted()) return;

    QWebView::mousePressEvent(event);
}

void WebView::mouseMoveEvent(QMouseEvent *event) {
    if ( event->pos().y()<0 ) {
        qDebug() << "something odd is going on!!!!!!!" << event->pos().y();
        return;
    }

    Flickable::handleMouseMove(event);
}

void WebView::mouseReleaseEvent(QMouseEvent *event) {
    Flickable::handleMouseRelease(event);
    if (event->isAccepted()) return;

    QWebView::mouseReleaseEvent(event);
}

QWebView*  WebView::createWindow ( QWebPage::WebWindowType type )
{
    Q_UNUSED(type);

    MainWindow* new_window = new MainWindow();
    new_window->show();

    return new_window->getWebView();
}
