#ifndef WEBPAGE_H
#define WEBPAGE_H

#include "networkcookiejar.h"

class WebPage : public QWebPage
{
private:
    NetworkCookieJar* cookieJar;

public:
    QString userAgentForUrl(const QUrl &url ) const{
        if ( !m_iphoneUserAgent ) return QWebPage::userAgentForUrl(url);

        Q_UNUSED(url);
        return QString("Mozilla/5.0 (iPhone; U; CPU iPhone OS 3_1 like Mac OS X; en-us) AppleWebKit/528.18 (KHTML, like Gecko) Version/4.0 Mobile/7C97d Safari/528.16");
    }

    WebPage() {
        m_iphoneUserAgent = true;
        cookieJar = new NetworkCookieJar;
        networkAccessManager()->setCookieJar(cookieJar);
    }

    void saveCookies() {
        cookieJar->saveCookies();
    }

    void setIPhoneUserAgent(bool value=true) {
        m_iphoneUserAgent = value;
    }

    bool isIphoneUserAgent() {
        return m_iphoneUserAgent;
    }

public slots:
    //void

private:
    bool m_iphoneUserAgent;
};

#endif // WEBPAGE_H
