#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include "webview.h"
#include "errorbox.h"
#include "toolbar.h"
#include "minifiedtoolbar.h"
#include "bookmark.h"
#include "webpage.h"

#include <QLabel>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow {
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    virtual ~MainWindow();

    //manually adapt layout to new size
    void adjustSizes();

    void keyPressEvent(QKeyEvent *event);

    QWebView* getWebView();

private:
    void loadSettings();
    void saveSettings();

    bool isFullScreen();

    // reimplement resize event to adapt layout
    void resizeEvent(QResizeEvent* event);

    //intercepts close event
    void closeEvent(QCloseEvent *event);

    void zoomIn();
    void zoomOut();

    void disableWebkitAutoSize();

    void setUserAgent(bool iphone=true);

#ifdef Q_WS_MAEMO_5
    void grabZoomKeys(bool grab);
    bool isLandscape();
    bool isAutoRotate();
    void setLandscape(bool landscape=true, bool force=false);
    void setAutoRotate(bool autoRotate=true);
#else
    //white overlay behind the error message
    void showOverlayOnPage();
    void hideOverlayOnPage();
#endif

private slots:
    void on_actionUser_Agent_triggered();
    void on_actionAdd_Bookmark_triggered();
    void on_actionGo_To_triggered();
    void on_actionAuto_Rotate_triggered();
    void on_actionLandscape_triggered();
    void on_actionBookmarks_triggered();
    void on_actionHome_triggered();

    void setFullScreen(bool full=true);
    void showLoading(); //called when a "loading page" is started
    void changeUrl(QUrl url); //called when the url is changed. The url will be used on the retry action
    void hideLoading(bool success); //called when a "loading page" is finished
    void reload(); //reload the page
    void finishedRequest(QNetworkReply* reply); //request

#ifdef Q_WS_MAEMO_5
    void orientationChanged();
    void fullscreen_triggered();

#else
    //toolbar visibility control
    void showToolbar();
    void hideToolbar();

#endif

    //visit url
    void visitUrl(QString);

private:
    // mainWindow components
    QUrl m_currentUrl;
    QVector<int> m_zoomLevels;
    int m_currentZoom;
    Ui::MainWindow *m_pUI;
    QLabel* m_pLoadingLabel;
    QList<Bookmark> m_bookmarks;
    WebPage m_webPage;

    QStringList m_errors;

#ifndef Q_WS_MAEMO_5
    ErrorBox* m_pErrorBox;
    Toolbar* m_pToolbar;
    MinifiedToolbar* m_pMiniToolbar;
#endif

};

#endif // MAINWINDOW_H
