TEMPLATE = app
TARGET = macuco2
SOURCES = flickable.cpp \
    main.cpp \
    webview.cpp \
    errorbox.cpp \
    networkcookiejar.cpp \
    toolbar.cpp \
    minifiedtoolbar.cpp \
    mainwindow.cpp \
    gotodlg.cpp \
    bookmark.cpp \
    bookmarksdlg.cpp \
    bookmarkdlg.cpp
HEADERS = flickable.h \
    webview.h \
    webpage.h \
    errorbox.h \
    networkcookiejar.h \
    toolbar.h \
    minifiedtoolbar.h \
    mainwindow.h \
    fullscreenexitbutton.h \
    gotodlg.h \
    bookmark.h \
    bookmarksdlg.h \
    bookmarkdlg.h 
QT += network \
    webkit
FORMS += errorbox.ui \
    toolbar.ui \
    minifiedtoolbar.ui \
    mainwindow.ui \
    gotodlg.ui \
    bookmarksdlg.ui \
    bookmarkdlg.ui
RESOURCES += resources.qrc
unix { 

    # VARIABLES
    isEmpty(PREFIX):PREFIX = debian
    BINDIR = $$PREFIX/$${TARGET}/usr/bin
    DATADIR = $$PREFIX/$${TARGET}/usr/share
    DEFINES += DATADIR=\"$$DATADIR\" \
        PKGDATADIR=\"$$PKGDATADIR\"

    # VARIABLES
    # isEmpty(PREFIX):PREFIX = /usr/local
    # BINDIR = $$PREFIX/bin
    # DATADIR = $$PREFIX/share
    
    # MAKE INSTALL
    INSTALLS += target \
        desktop \
        iconxpm \
        icon26 \
        icon40 \
        icon64
    target.path = $$BINDIR
    desktop.path = $$DATADIR/applications/hildon
    desktop.files += macuco2.desktop
    iconxpm.path = $$DATADIR/pixmap
    iconxpm.files += data/maemo/macuco2.xpm
    icon26.path = $$DATADIR/icons/hicolor/26x26/apps
    icon26.files += data/26x26/macuco2.png
    icon40.path = $$DATADIR/icons/hicolor/40x40/apps
    icon40.files += data/40x40/macuco2.png
    icon64.path = $$DATADIR/icons/hicolor/64x64/apps
    icon64.files += data/64x64/macuco2.png
}

# HOW TO MAKE IT CONDITIONAL?
DEFINES += QT_NO_DEBUG_OUTPUT QT_NO_WARNING_OUTPUT
