#include "bookmark.h"

#include <QList>

Bookmark::Bookmark() :
    m_title(QString::null),
    m_url(QString::null)
{
}

Bookmark::Bookmark(QString title, QString url) :
    m_title(title),
    m_url(url)
{
}

Bookmark::~Bookmark() {
}

QString Bookmark::title() const {
    return m_title;
}

QString Bookmark::url() const {
    return m_url;
}

void Bookmark::setTitle(QString value) {
    m_title = value;
}

void Bookmark::setUrl(QString value) {
    m_url =value;
}

void Bookmark::registerMeataType() {
    qRegisterMetaType<Bookmark>("Bookmark");
    qRegisterMetaTypeStreamOperators<Bookmark>("Bookmark");

    qRegisterMetaType< QList<Bookmark> >("QList<Bookmark>");
    qRegisterMetaTypeStreamOperators< QList<Bookmark> >("QList<Bookmark>");
}

bool Bookmark::isNull() {
    return m_url.isNull() || m_title.isNull();
}

bool Bookmark::operator==(const Bookmark& other) {
    return m_title==other.m_title;
}

// serialization
QT_BEGIN_NAMESPACE
QDataStream &operator<<(QDataStream &out, const Bookmark &bookmark) {
    out << bookmark.title();
    out << bookmark.url();

    return out;
}
QDataStream &operator>>(QDataStream &in, Bookmark &bookmark) {
    QString str;
    in >> str; bookmark.setTitle(str);
    in >> str; bookmark.setUrl(str);

    return in;
}
QT_END_NAMESPACE
// end: serialization


