/*
 * This file is part of M3-Weather program
 * This is header file of widget
 *
 * Copyright (C) 2010 - Ivan Galov, Anna Samoryadova
 * Petrozavodsk State University
 *
 * M3-Weather program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * M3-Weather program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with M3-Weather program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifndef MYWIDGET_H
#define MYWIDGET_H

#include <QLabel>
#include <QPushButton>
#include <QtGui/qpainter.h>
#include <QDebug>
#include <QProcess>
#include <QHBoxLayout>
#include <QVBoxLayout>

#define IMG_PATH "/usr/local/share/m3-weather/images/"

class SibThread;

/* widget object */
class MyWidget : public QWidget
{
    Q_OBJECT

public:
	/* constructor and destructor */
    MyWidget(QWidget *parent = 0);
	~MyWidget();
	bool checkGPS();
	QString getIP();
	QString getID();
	void setIP(QString l_ip);
	void setID(QString l_id);

public slots:
	void indication();
	void updateCity(QString);
	void updateTemp(QString);
	void updateIcon(QString);
	void updateCaption(QString);
	void startGPS();
	void stopGPS();
	void changeGPS();
	void showSettingsDialog();
	void restartConnection();
	
protected:
	/* drawing widget */
    void paintEvent(QPaintEvent *event);
    bool checkConfig();
	void makeConfig();
	QLabel *city; // label for city name
	QLabel *tmp;  // label for temperature
	QLabel *t;	  // label for 
    QPushButton *but; // button object (for image)
	QPushButton *gps_but;
	QString ip;
	QString uuid;
	QVBoxLayout *layout;
	QVBoxLayout *layout1;
	QHBoxLayout *layout2;
	QVBoxLayout *layout3;
	QProcess gpsc;
	bool gps;
	SibThread *s;
};

#endif
