#include "settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) : QDialog(parent)
{
	mv = (MyWidget*)parent;
	
	local_ip = mv->getIP();
	local_id = mv->getID();

	this->setWindowTitle("Settings");

	QLabel *label_ip = new QLabel("Server IP:");
	QLabel *label_id = new QLabel("Client ID:");
	edit_ip = new QLineEdit();
	edit_id = new QLineEdit();
	QPushButton *but_ok = new QPushButton("OK");
	QPushButton *but_reconnect = new QPushButton("Reconnect\nSIB");
	QPushButton *but_def_ip = new QPushButton("Reset\nIP");
	but_gps = new QPushButton();

	if(mv->checkGPS())
		but_gps->setText("GPS\nON");
	else
		but_gps->setText("GPS\nOFF");

	edit_ip->setText(local_ip);
	edit_id->setText(local_id);

	QFont font = edit_id->font();
	font.setPointSize(12);
	edit_id->setFont(font);

	edit_ip->setMinimumWidth(350);
	edit_id->setMinimumWidth(350);
	//but_def_ip->setMinimumWidth(150);

	QVBoxLayout *vl = new QVBoxLayout();
	//QHBoxLayout *hl = new QHBoxLayout();

	//hl->addWidget(but_gps);
	//hl->addWidget(but_reconnect);

	QGridLayout *gl = new QGridLayout();
	gl->addWidget(label_ip, 0, 0, Qt::AlignLeft);
	gl->addWidget(edit_ip, 0, 1, Qt::AlignLeft);
	gl->addWidget(label_id, 1, 0, Qt::AlignLeft);
	gl->addWidget(edit_id, 1, 1, Qt::AlignLeft);
	gl->addWidget(but_def_ip, 0, 3, 0);
	gl->addWidget(but_gps, 0, 4, Qt::AlignLeft);
	gl->addWidget(but_reconnect, 1, 3, 0);
	gl->addWidget(but_ok, 1, 4, Qt::AlignLeft);

	gl->setColumnStretch(2,1);
	vl->addLayout(gl);

	this->setLayout(vl);

	QObject::connect(but_gps, SIGNAL(clicked()), this, SLOT(changeGPSstate()));
	QObject::connect(but_ok, SIGNAL(clicked()), this, SLOT(saveSettings()));
	QObject::connect(but_reconnect, SIGNAL(clicked()), this, SLOT(restartConnection()));
	QObject::connect(but_def_ip, SIGNAL(clicked()), this, SLOT(resetIP()));

	this->show();
}

void SettingsDialog::changeGPSstate()
{
	if(mv->checkGPS()) {
		but_gps->setText("GPS\nOFF");
		mv->stopGPS();
	}
	else {
		but_gps->setText("GPS\nON");
		mv->startGPS();
	}
}

void SettingsDialog::getConfigData()
{
	QFile homefile(QDir::homePath() + CONFIG_FILENAME);
	QTextStream stream(&homefile);
	homefile.open (QIODevice::ReadOnly);
	QString line;
	QStringList list;

	line = stream.readLine();
	list = line.split("=", QString::SkipEmptyParts);
	local_ip = list.at(1);

	line = stream.readLine();
	list = line.split("=", QString::SkipEmptyParts);
	local_id = list.at(1);

	homefile.close();
}

void SettingsDialog::writeConfig()
{
	QFile homefile(QDir::homePath()+ CONFIG_FILENAME);
	QTextStream stream(&homefile);
	homefile.open(QIODevice::WriteOnly | QIODevice::Truncate);
	stream << "ip=";
 	stream << edit_ip->text();
	stream << "\n";
	stream << "id=";
	stream << edit_id->text();
	stream << "\n";
	homefile.close();
}

void SettingsDialog::saveSettings()
{
	if(!checkIP()) {
		QMaemo5InformationBox::information(this, "Incorrect IP address", QMaemo5InformationBox::DefaultTimeout);
		return;
	}

	if(mv->getIP() != edit_ip->text()) {
		writeConfig();
		mv->setIP(edit_ip->text());
		mv->setID(edit_id->text());

		if(mv->checkGPS()) {
			mv->stopGPS();
			mv->startGPS();
		}

		mv->restartConnection();

	}

	this->close();
}

void SettingsDialog::restartConnection()
{
	if(!checkIP()) {
		QMaemo5InformationBox::information(this, "Incorrect IP address", QMaemo5InformationBox::DefaultTimeout);
		return;
	}
	
	if(mv->getIP() != edit_ip->text()) {
		writeConfig();
		mv->setIP(edit_ip->text());
		mv->setID(edit_id->text());
	}

	if(mv->checkGPS()) {
		mv->stopGPS();
		mv->startGPS();
	}
	
	mv->restartConnection();
}

bool SettingsDialog::checkIP()
{
	QRegExp *qr = new QRegExp();
	qr->setPattern("^[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}[.]{1}[0-9]{1,3}$");
	return qr->exactMatch(edit_ip->text());
}

void SettingsDialog::resetIP()
{
	edit_ip->setText("194.85.173.9");
}
