/*
 * This file is part of M3-Weather program
 * This is file containing functions for interaction with SIB
 *
 * Copyright (C) 2010 - Ivan Galov
 * Petrozavodsk State University
 *
 * M3-Weather program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * M3-Weather program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with M3-Weather program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#include "thread.h"
#include <string.h>
#include <QDir>
#include "mywidget.h"


SibThread::SibThread(QWidget *parent)
{
	mv = (MyWidget*)parent;
	ip = mv->getIP();
	uuid = mv->getID();
	qDebug() << "Get Session";
	session = mv->getSession();
	
		
	QObject::connect(this, SIGNAL(indication()), mv, SLOT(indication()));
	QObject::connect(this, SIGNAL(updateCity(QString)), mv, SLOT(updateCity(QString)));
	QObject::connect(this, SIGNAL(updateTemp(QString)), mv, SLOT(updateTemp(QString)));
	QObject::connect(this, SIGNAL(updateIcon(QString)), mv, SLOT(updateIcon(QString)));
	QObject::connect(this, SIGNAL(updateCaption(QString)), mv, SLOT(updateCaption(QString)));
	QObject::connect(this, SIGNAL(startGPS()), mv, SLOT(startGPS()));
	
}

SibThread::~SibThread()
{
ss_unsubscribe(&ss_info, &subs_info);
ss_leave(&ss_info);
printf("\nLEAVE\n");

}

void SibThread::run()
{

qDebug("Wait for opened!");
	if (session->waitForOpened(-1))
		qDebug("Open!");
	else
		return;

printf("\nSTART\n");

printf("1\n");
ss_discovery(&ss_info);
printf("2\n");

strncpy(ss_info.space_id, "X", SS_SPACE_ID_MAX_LEN);
strncpy(ss_info.address.ip, ip.toUtf8().data(), MAX_IP_LEN);
ss_info.address.port = 10010;

printf("3\n");

if (ss_join(&ss_info, "KP_GUI") == -1) {
	printf("\nCan't join to SS\n");
}
else
	printf("\nJoined to SS\n");

printf("4\n");

QString line("1");
QString city;
QString weather;


/* subscription */

city = "city-"+uuid;
weather = "weather-"+uuid;
ss_triple_t * first_triple = NULL;
ss_triple_t * result_triple = NULL;
ss_triple_t * triple = NULL;


ss_add_triple(&first_triple, city.toUtf8().data(), "name", SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_URI);
ss_add_triple(&first_triple, weather.toUtf8().data(), "temp", SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_URI);
ss_add_triple(&first_triple, weather.toUtf8().data(), "icon", SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_URI);
ss_add_triple(&first_triple, weather.toUtf8().data(), "caption", SS_RDF_SIB_ANY, SS_RDF_TYPE_URI, SS_RDF_TYPE_URI);

if (ss_subscribe(&ss_info, &subs_info, first_triple, &result_triple) < 0) {
	printf("Failed to subscribe\n");
}

printf("\nSUBSCRIBE\n");

triple = result_triple;

while(triple) {
	printf("%s\n", triple->predicate);
    printf("%s\n", triple->object);


	if(strcmp(triple->predicate, "name") == 0)
		emit updateCity(QString(triple->object));
	if(strcmp(triple->predicate, "temp") == 0)
		emit updateTemp(QString(triple->object));
	if(strcmp(triple->predicate, "icon") == 0)
		emit updateIcon(QString(triple->object));
	if(strcmp(triple->predicate, "caption") == 0)
		emit updateCaption(QString(triple->object));


	emit indication();

    triple = triple->next;
}

ss_delete_triples(first_triple);
ss_delete_triples(result_triple);


int status;

printf("\nINDICATION\n");

while(1) {

	ss_triple_t * n_val = NULL;
    ss_triple_t * o_val = NULL;
    
    status = ss_subscribe_indication(&ss_info, &subs_info, &n_val, &o_val, 1000);
    
    if(status == 0)
      continue; 
    
    if(status < 0)
    {
      continue;
    }
    if(status == 1)
    {
      printf("\nReceived subscribe indication [ID = %s]\n", subs_info.id);

		emit indication();

      triple = n_val;
      while(triple)
      {
        printf("%s\n", triple->predicate);
        printf("%s\n", triple->object);

		if(strcmp(triple->predicate, "name") == 0)
			emit updateCity(QString(triple->object));
		if(strcmp(triple->predicate, "temp") == 0)
			emit updateTemp(QString(triple->object));
		if(strcmp(triple->predicate, "icon") == 0)
			emit updateIcon(QString(triple->object));
		if(strcmp(triple->predicate, "caption") == 0)
			emit updateCaption(QString(triple->object));

        triple = triple->next;
      }
      
      ss_delete_triples(n_val);
      ss_delete_triples(o_val);
      n_val = NULL;
      o_val = NULL;
      
    }
}

}
