/*
 * This file is part of M3-Weather program
 * This is main file of KP-GPScoords
 *
 * Copyright (C) 2010 - Pavel Borovinskiy, Ivan Galov
 * Petrozavodsk State University
 *
 * M3-Weather program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * M3-Weather program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with M3-Weather program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#include <location/location-gps-device.h>
#include <location/location-gpsd-control.h>
#include <signal.h>
#include "weather.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

individual_t *coords;

char oldval[100];
char newval[100];
double lat=0;
double lon=0;
double timestamp=0;
void signal_handler(int signum) {

	ss_remove_properties_by_name(coords, PROPERTY_POS->name);
	ss_remove_individual(coords);

    clean_repositories();
    ss_leave(get_ss_info());
    
    printf("\nKP leave SS...\n");

	printf("\n");
	exit(0);

}


static void on_error(LocationGPSDControl *control, LocationGPSDControlError error, gpointer data)
{ 
	g_debug("location error: %d... quitting", error);
	g_main_loop_quit((GMainLoop *) data);
}

static void on_changed(LocationGPSDevice *device, gpointer data)
{
	printf("\nCHANGED!!!!!\n");

	if (!device)
		return;

	if (device->fix) {
		double latdif;
		double londif;	
		if (device->fix->fields & LOCATION_GPS_DEVICE_LATLONG_SET) {
			
			printf("lat = %f, long = %f\n", device->fix->latitude, device->fix->longitude);
			//sscanf(oldval, "%f;%f", &lat, &lon);
			printf("lat = %f, long = %f\n", lat, lon);
			latdif= abs (lat - device->fix->latitude);
			londif= abs (lon - device->fix->longitude);
						
			if (latdif>=1 || londif>=1 && lat!= device->fix->latitude && lon != device->fix->longitude || (device->fix->time - timestamp)>3600 ){
			       //printf("%f %f\n", latdif, londif);
				
			       sprintf(newval, "%f;%f", device->fix->latitude, device->fix->longitude);
					printf("WRITE TO SIB\n");
					printf("%s\n", oldval);
					printf("%s\n", newval);			
			       ss_update_property_with_data(coords, PROPERTY_POS->name, oldval, newval);
			       lat=device->fix->latitude;
			       lon=device->fix->longitude;
			       strcpy(oldval, newval);
			       timestamp=device->fix->time;
			}
			//location_gpsd_control_stop((LocationGPSDControl *) data);
		}
	}
} 

static void on_stop(LocationGPSDControl *control, gpointer data)
{
	g_debug("quitting");
	g_main_loop_quit((GMainLoop *) data);
} 

static gboolean start_location(gpointer data)
{
	location_gpsd_control_start((LocationGPSDControl *) data);
	printf("\nSTART!!!!\n");
	return FALSE;
}

int main(int argc, char *argv[])
{
	
	LocationGPSDControl *control;
	LocationGPSDevice *device;
	GMainLoop *loop;
        g_type_init();


	signal(SIGINT, signal_handler);
	signal(SIGTERM, signal_handler);

    	
        static const char *homefile[256];
	sprintf (homefile, "%s/.m3w-client.conf",getenv("HOME"));
	FILE *input;
	char server_ip[50];
	char id[50]; 
	strncpy(server_ip,"194.85.173.9",16);
	strncpy(id,"1",40);
	char kpname[60];
	char uuid[60];
	strncpy(kpname,"KP_GPSCOORDS",10);
	strncpy(uuid,"coords-",10);
	    
	
	input = fopen(homefile,"r");
  	if (input != NULL)
		{
		printf ("Finded in /home \n");		
		fscanf (input,"ip=%s\n",server_ip);		
		fscanf (input,"id=%s",id);
		fclose (input);
	}
	
	if (argc > 1) {
		strncpy(id, argv[1], 40);
	}

	strcat(kpname,id);
	strcat(uuid,id);
	init_ss_with_parameters("X", server_ip, 10010);    
	register_ontology();
    
    if (ss_join(get_ss_info(), kpname) == -1) {
        printf("Can't join to SS\n");
    }

    printf("\nKP join to SS\n");

// Set your code.	
	coords = new_individual(CLASS_COORDS);
	init_individual_with_uuid(coords, uuid);
	coords->uuid = strdup(uuid);
	
	strcpy(oldval, "blank");
	strcpy(newval, "10;10");

	loop = g_main_loop_new(NULL, FALSE);

	control = location_gpsd_control_get_default();
	device = g_object_new(LOCATION_TYPE_GPS_DEVICE, NULL);

	g_object_set(G_OBJECT(control),
		"preferred-method", LOCATION_METHOD_USER_SELECTED,
		"preferred-interval", LOCATION_INTERVAL_DEFAULT,
		NULL);

	g_signal_connect(control, "error-verbose", G_CALLBACK(on_error), loop);
	g_signal_connect(device, "changed", G_CALLBACK(on_changed), control);
	g_signal_connect(control, "gpsd-stopped", G_CALLBACK(on_stop), loop);

	g_idle_add(start_location, control);

	g_main_loop_run(loop);

	g_object_unref(device);
	g_object_unref(control);

	ss_remove_properties_by_name(coords, PROPERTY_POS->name);
	ss_remove_individual(coords);

    clean_repositories();
    ss_leave(get_ss_info());
    
    printf("\nKP leave SS...\n");

	return 0;
}
