/*
 * This file is part of M3-Weather program
 * This is ontology-based file generated by SmartSlog generator
 *
 * Copyright (C) 2010 - Borovinskiy Pavel, Galov Ivan
 * Petrozavodsk State University
 *
 * M3-Weather program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * M3-Weather program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with M3-Weather program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#include "weather.h"


/**
 * @brief Register ontology.
 *
 * It creates all structures, such as classes and properties. Use it firs in your propgramm.
 */
void register_ontology()
{    
    list_t *tmp_node = NULL;    

#if INCLUDE_PROPERTY_POS

PROPERTY_POS =  (property_t *) malloc(sizeof(property_t));
PROPERTY_POS->name = strdup("pos");
PROPERTY_POS->about = strdup("#pos");
//PROPERTY_POS->range = "http://www.w3.org/2001/XMLSchema#integer"; //getRange
PROPERTY_POS->domain = strdup("#Coords"); 
PROPERTY_POS->maxcardinality = -1;
PROPERTY_POS->mincardinality = -1;
PROPERTY_POS->subpropertyof = NULL;
PROPERTY_POS->oneof = list_get_new_list();  
PROPERTY_POS->rtti = RTTI_PROPERTY;
PROPERTY_POS->type = DATATYPEPROPERTY;



add_entity_to_repository((void *) PROPERTY_POS);

#endif
#if INCLUDE_PROPERTY_PROCESSED

PROPERTY_PROCESSED =  (property_t *) malloc(sizeof(property_t));
PROPERTY_PROCESSED->name = strdup("processed");
PROPERTY_PROCESSED->about = strdup("#processed");
//PROPERTY_PROCESSED->range = "http://www.w3.org/2001/XMLSchema#string"; //getRange
PROPERTY_PROCESSED->domain = strdup("#City"); 
PROPERTY_PROCESSED->maxcardinality = -1;
PROPERTY_PROCESSED->mincardinality = -1;
PROPERTY_PROCESSED->subpropertyof = NULL;
PROPERTY_PROCESSED->oneof = list_get_new_list();  
PROPERTY_PROCESSED->rtti = RTTI_PROPERTY;
PROPERTY_PROCESSED->type = DATATYPEPROPERTY;



add_entity_to_repository((void *) PROPERTY_PROCESSED);

#endif
#if INCLUDE_PROPERTY_ICON

PROPERTY_ICON =  (property_t *) malloc(sizeof(property_t));
PROPERTY_ICON->name = strdup("icon");
PROPERTY_ICON->about = strdup("#icon");
//PROPERTY_ICON->range = "http://www.w3.org/2001/XMLSchema#integer"; //getRange
PROPERTY_ICON->domain = strdup("#Weather"); 
PROPERTY_ICON->maxcardinality = -1;
PROPERTY_ICON->mincardinality = -1;
PROPERTY_ICON->subpropertyof = NULL;
PROPERTY_ICON->oneof = list_get_new_list();  
PROPERTY_ICON->rtti = RTTI_PROPERTY;
PROPERTY_ICON->type = DATATYPEPROPERTY;



add_entity_to_repository((void *) PROPERTY_ICON);

#endif
#if INCLUDE_PROPERTY_NAME

PROPERTY_NAME =  (property_t *) malloc(sizeof(property_t));
PROPERTY_NAME->name = strdup("name");
PROPERTY_NAME->about = strdup("#name");
//PROPERTY_NAME->range = "http://www.w3.org/2001/XMLSchema#string"; //getRange
PROPERTY_NAME->domain = strdup("#City"); 
PROPERTY_NAME->maxcardinality = -1;
PROPERTY_NAME->mincardinality = -1;
PROPERTY_NAME->subpropertyof = NULL;
PROPERTY_NAME->oneof = list_get_new_list();  
PROPERTY_NAME->rtti = RTTI_PROPERTY;
PROPERTY_NAME->type = DATATYPEPROPERTY;



add_entity_to_repository((void *) PROPERTY_NAME);

#endif
#if INCLUDE_PROPERTY_CITYID

PROPERTY_CITYID =  (property_t *) malloc(sizeof(property_t));
PROPERTY_CITYID->name = strdup("cityid");
PROPERTY_CITYID->about = strdup("#cityid");
//PROPERTY_CITYID->range = "http://www.w3.org/2001/XMLSchema#string"; //getRange
PROPERTY_CITYID->domain = strdup("#City"); 
PROPERTY_CITYID->maxcardinality = -1;
PROPERTY_CITYID->mincardinality = -1;
PROPERTY_CITYID->subpropertyof = NULL;
PROPERTY_CITYID->oneof = list_get_new_list();  
PROPERTY_CITYID->rtti = RTTI_PROPERTY;
PROPERTY_CITYID->type = DATATYPEPROPERTY;



add_entity_to_repository((void *) PROPERTY_CITYID);

#endif
#if INCLUDE_PROPERTY_CAPTION

PROPERTY_CAPTION =  (property_t *) malloc(sizeof(property_t));
PROPERTY_CAPTION->name = strdup("caption");
PROPERTY_CAPTION->about = strdup("#caption");
//PROPERTY_CAPTION->range = "http://www.w3.org/2001/XMLSchema#string"; //getRange
PROPERTY_CAPTION->domain = strdup("#Weather"); 
PROPERTY_CAPTION->maxcardinality = -1;
PROPERTY_CAPTION->mincardinality = -1;
PROPERTY_CAPTION->subpropertyof = NULL;
PROPERTY_CAPTION->oneof = list_get_new_list();  
PROPERTY_CAPTION->rtti = RTTI_PROPERTY;
PROPERTY_CAPTION->type = DATATYPEPROPERTY;



add_entity_to_repository((void *) PROPERTY_CAPTION);

#endif
#if INCLUDE_PROPERTY_TEMP

PROPERTY_TEMP =  (property_t *) malloc(sizeof(property_t));
PROPERTY_TEMP->name = strdup("temp");
PROPERTY_TEMP->about = strdup("#temp");
//PROPERTY_TEMP->range = "http://www.w3.org/2001/XMLSchema#integer"; //getRange
PROPERTY_TEMP->domain = strdup("#Weather"); 
PROPERTY_TEMP->maxcardinality = -1;
PROPERTY_TEMP->mincardinality = -1;
PROPERTY_TEMP->subpropertyof = NULL;
PROPERTY_TEMP->oneof = list_get_new_list();  
PROPERTY_TEMP->rtti = RTTI_PROPERTY;
PROPERTY_TEMP->type = DATATYPEPROPERTY;



add_entity_to_repository((void *) PROPERTY_TEMP);

#endif




#if INCLUDE_CLASS_WEATHER

CLASS_WEATHER = (class_t *) malloc(sizeof(class_t));
CLASS_WEATHER->rtti = RTTI_CLASS;
CLASS_WEATHER->classtype =  strdup("#Weather");
CLASS_WEATHER->properties = list_get_new_list();  
CLASS_WEATHER->instances = NULL;
CLASS_WEATHER->superclasses = list_get_new_list();  
CLASS_WEATHER->oneof = list_get_new_list();  

add_entity_to_repository((void *) CLASS_WEATHER);

#if INCLUDE_PROPERTY_ICON
tmp_node = list_get_new_node(PROPERTY_ICON);
list_add_node(tmp_node, CLASS_WEATHER->properties);
#endif
#if INCLUDE_PROPERTY_TEMP
tmp_node = list_get_new_node(PROPERTY_TEMP);
list_add_node(tmp_node, CLASS_WEATHER->properties);
#endif
#if INCLUDE_PROPERTY_CAPTION
tmp_node = list_get_new_node(PROPERTY_CAPTION);
list_add_node(tmp_node, CLASS_WEATHER->properties);
#endif

#endif
#if INCLUDE_CLASS_COORDS

CLASS_COORDS = (class_t *) malloc(sizeof(class_t));
CLASS_COORDS->rtti = RTTI_CLASS;
CLASS_COORDS->classtype =  strdup("#Coords");
CLASS_COORDS->properties = list_get_new_list();  
CLASS_COORDS->instances = NULL;
CLASS_COORDS->superclasses = list_get_new_list();  
CLASS_COORDS->oneof = list_get_new_list();  

add_entity_to_repository((void *) CLASS_COORDS);

#if INCLUDE_PROPERTY_POS
tmp_node = list_get_new_node(PROPERTY_POS);
list_add_node(tmp_node, CLASS_COORDS->properties);
#endif

#endif
#if INCLUDE_CLASS_CITY

CLASS_CITY = (class_t *) malloc(sizeof(class_t));
CLASS_CITY->rtti = RTTI_CLASS;
CLASS_CITY->classtype =  strdup("#City");
CLASS_CITY->properties = list_get_new_list();  
CLASS_CITY->instances = NULL;
CLASS_CITY->superclasses = list_get_new_list();  
CLASS_CITY->oneof = list_get_new_list();  

add_entity_to_repository((void *) CLASS_CITY);

#if INCLUDE_PROPERTY_PROCESSED
tmp_node = list_get_new_node(PROPERTY_PROCESSED);
list_add_node(tmp_node, CLASS_CITY->properties);
#endif
#if INCLUDE_PROPERTY_NAME
tmp_node = list_get_new_node(PROPERTY_NAME);
list_add_node(tmp_node, CLASS_CITY->properties);
#endif
#if INCLUDE_PROPERTY_CITYID
tmp_node = list_get_new_node(PROPERTY_CITYID);
list_add_node(tmp_node, CLASS_CITY->properties);
#endif

#endif
#if INCLUDE_CLASS_NOTHING

CLASS_NOTHING = (class_t *) malloc(sizeof(class_t));
CLASS_NOTHING->rtti = RTTI_CLASS;
CLASS_NOTHING->classtype =  strdup("http://www.w3.org/2002/07/owl#Nothing");
CLASS_NOTHING->properties = list_get_new_list();  
CLASS_NOTHING->instances = NULL;
CLASS_NOTHING->superclasses = list_get_new_list();  
CLASS_NOTHING->oneof = list_get_new_list();  

add_entity_to_repository((void *) CLASS_NOTHING);

#if INCLUDE_PROPERTY_PROCESSED
tmp_node = list_get_new_node(PROPERTY_PROCESSED);
list_add_node(tmp_node, CLASS_NOTHING->properties);
#endif
#if INCLUDE_PROPERTY_ICON
tmp_node = list_get_new_node(PROPERTY_ICON);
list_add_node(tmp_node, CLASS_NOTHING->properties);
#endif
#if INCLUDE_PROPERTY_TEMP
tmp_node = list_get_new_node(PROPERTY_TEMP);
list_add_node(tmp_node, CLASS_NOTHING->properties);
#endif
#if INCLUDE_PROPERTY_POS
tmp_node = list_get_new_node(PROPERTY_POS);
list_add_node(tmp_node, CLASS_NOTHING->properties);
#endif
#if INCLUDE_PROPERTY_NAME
tmp_node = list_get_new_node(PROPERTY_NAME);
list_add_node(tmp_node, CLASS_NOTHING->properties);
#endif
#if INCLUDE_PROPERTY_CITYID
tmp_node = list_get_new_node(PROPERTY_CITYID);
list_add_node(tmp_node, CLASS_NOTHING->properties);
#endif
#if INCLUDE_PROPERTY_CAPTION
tmp_node = list_get_new_node(PROPERTY_CAPTION);
list_add_node(tmp_node, CLASS_NOTHING->properties);
#endif

#endif
#if INCLUDE_CLASS_THING

CLASS_THING = (class_t *) malloc(sizeof(class_t));
CLASS_THING->rtti = RTTI_CLASS;
CLASS_THING->classtype =  strdup("http://www.w3.org/2002/07/owl#Thing");
CLASS_THING->properties = list_get_new_list();  
CLASS_THING->instances = NULL;
CLASS_THING->superclasses = list_get_new_list();  
CLASS_THING->oneof = list_get_new_list();  

add_entity_to_repository((void *) CLASS_THING);


#endif


#if INCLUDE_CLASS_WEATHER
#if INCLUDE_CLASS_THING
tmp_node = list_get_new_node(CLASS_THING);
list_add_node(tmp_node, CLASS_WEATHER->superclasses);
#endif
#endif
#if INCLUDE_CLASS_COORDS
#if INCLUDE_CLASS_THING
tmp_node = list_get_new_node(CLASS_THING);
list_add_node(tmp_node, CLASS_COORDS->superclasses);
#endif
#endif
#if INCLUDE_CLASS_CITY
#if INCLUDE_CLASS_THING
tmp_node = list_get_new_node(CLASS_THING);
list_add_node(tmp_node, CLASS_CITY->superclasses);
#endif
#endif
#if INCLUDE_CLASS_NOTHING
#if INCLUDE_CLASS_WEATHER
tmp_node = list_get_new_node(CLASS_WEATHER);
list_add_node(tmp_node, CLASS_NOTHING->superclasses);
#endif
#endif
#if INCLUDE_CLASS_NOTHING
#if INCLUDE_CLASS_COORDS
tmp_node = list_get_new_node(CLASS_COORDS);
list_add_node(tmp_node, CLASS_NOTHING->superclasses);
#endif
#endif
#if INCLUDE_CLASS_NOTHING
#if INCLUDE_CLASS_CITY
tmp_node = list_get_new_node(CLASS_CITY);
list_add_node(tmp_node, CLASS_NOTHING->superclasses);
#endif
#endif



}


