/*
 * This file is part of M3-Weather program
 * This is main file of KP-Coords
 *
 * Copyright (C) 2010 - Pavel Borovinskiy, Ivan Galov
 * Petrozavodsk State University
 *
 * M3-Weather program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * M3-Weather program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with M3-Weather program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#include <signal.h>
#include "weather.h"
#include <stdio.h>
#include <string.h>

individual_t *coords; // global individual "coords"

/* function - handler of ctrl+c */
void signal_handler(int signum) {

	/* end program correctly */
	
	/* remove propertie */
	ss_remove_properties_by_name(coords, PROPERTY_POS->name);
	
	/* remove individual */
	ss_remove_individual(coords);

	/* disconnect from SIB */
    clean_repositories();
    ss_leave(get_ss_info());

	printf("\n");
	exit(0);
}

/* main function of KP */
int main(int argc, char** argv)
{
	/* 
	  old and new values of properties to use in 
	  update property function 
	*/
	char oldval[20];
	char newval[20];

	/* set signal handler */
	signal(SIGINT, signal_handler);
	FILE *input;
	char server_ip[50];
	char id[50]; 
	strncpy(server_ip,"194.85.173.9",16);
	strncpy(id,"1",40);
	char kpname[60];
	char uuid[60];
	char uuidc[60];
	char uuidw[60];
	strncpy(kpname,"KP_COORDS",10);
	strncpy(uuid,"coords-",10);
	strncpy(uuidc,"city-",10);
	strncpy(uuidw,"weather-",10);


	static const char homefile[256];
	sprintf (homefile, "%s/.m3w-client.conf",getenv("HOME"));


	individual_t *city;
	individual_t *weather;


	/* 
	  initialize primary values of old properties
	  to work update property function correctly
	*/
	
	prop_val_t *p_val; // property structure
	/* connect to SIB */
    
	input = fopen(homefile,"r");
  	if (input != NULL)
		{
		printf ("Preferences found in /home \n");		
		fscanf (input,"ip=%s\n", server_ip);		
		fscanf (input,"id=%s", id);
		fclose (input);
	}
	
	if (argc > 1) {
		strncpy(id, argv[1], 40);
	}

	strcat(kpname,id);
	strcat(uuid,id);
	strcat(uuidc,id);
	strcat(uuidw,id);

	printf("IP: %s\n", server_ip);
	printf("ID: %s\n", id);

	/* connect to SIB */
	init_ss_with_parameters("X", server_ip, 10010);
	   
	register_ontology();
    
    /* joining SIB */

    if (ss_join(get_ss_info(), kpname) == -1) {
        printf("Can't join to SS\n");
        return 0;
    }

    printf("\nKP join to SS\n");

	/* create new individual "coords" and set it's uuid */
	coords = new_individual(CLASS_COORDS);
	city = new_individual(CLASS_COORDS);
	weather = new_individual(CLASS_COORDS);

	init_individual_with_uuid(coords, uuid);
	coords->uuid = strdup(uuid);
	city->uuid = strdup(uuidc);
	weather->uuid = strdup(uuidw);

	
	
	/* 
	  initialize primary values of old properties
	  to work update property function correctly
	*/
	strcpy(oldval, "blank");

	/* 
		infinite cicle of publishing coordinates
		exiting on ctrl+c
	*/
	while(true) {
		printf("\nEnter coordinates:\n");
		/* get coordinates */
		scanf("%s", newval);
		printf("%s %s\n", oldval, newval);
		if (strcmp(newval, "q") == 0)
			break;

		ss_remove_properties_by_name(city, PROPERTY_NAME->name);
		ss_remove_properties_by_name(city, PROPERTY_CITYID->name);
		
		ss_remove_properties_by_name(weather, PROPERTY_TEMP->name);
		ss_remove_properties_by_name(weather, PROPERTY_CAPTION->name);
		ss_remove_properties_by_name(weather, PROPERTY_ICON->name);

		/* update coordinates information in SIB */
		ss_update_property_with_data(coords, PROPERTY_POS->name, strdup(oldval), strdup(newval));
		printf("%s %s\n", oldval, newval);
		
		/* save new values as old to next updating */
		strcpy(oldval, newval);
	}

	/* end program correctly */

	/* remove properties */
	ss_remove_properties_by_name(coords, PROPERTY_POS->name);
	
	/* remove individual */
	ss_remove_individual(coords);

	/* disconnect form SIB */
    clean_repositories();
    ss_leave(get_ss_info());
    
    printf("\nKP leave SS...\n");

    return 0;
}
