/*
 * Copyright (C) 2009 Till Harbaum <till@harbaum.org>.
 *
 * This file is part of zeemote-conf.
 *
 * zeemote-conf is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * zeemote-conf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with zeemote-conf.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include <gconf/gconf.h>
#include <gconf/gconf-client.h>

#include <zeemote.h>
#include "zeemote-conf.h"
#include "zeemote-conf-paths.h"

zeemote_scan_result_t *zeemote_get_scan_results_from_gconf(void) {
  int i;

  GConfClient *gconf_client = gconf_client_get_default();

  int devices = gconf_client_get_int(gconf_client, 
				     GCONF_KEY_DEVICES, NULL);

  zeemote_scan_result_t *result = malloc(sizeof(zeemote_scan_result_t) + 
					 devices * sizeof(zeemote_device_t));
  memset(result, 0, sizeof(zeemote_scan_result_t) + 
	 devices * sizeof(zeemote_device_t));

  result->number_of_devices = devices;
  for(i=0;i<devices;i++) {
    char *key, *addr; 

    key = g_strdup_printf(GCONF_KEY_TYPE, i);
    result->device[i].type = gconf_client_get_int(gconf_client, key, NULL);
    g_free(key);

    key = g_strdup_printf(GCONF_KEY_BDADDR, i);
    addr = gconf_client_get_string(gconf_client, key, NULL);
    if(addr) baswap(&result->device[i].bdaddr, strtoba(addr));
    g_free(key);
  }
    
  return result;
}
