/*

Copyright 1988, 1998  The Open Group

Permission to use, copy, modify, distribute, and sell this software and its
documentation for any purpose is hereby granted without fee, provided that
the above copyright notice appear in all copies and that both that
copyright notice and this permission notice appear in supporting
documentation.

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

Except as contained in this notice, the name of The Open Group shall not be
used in advertising or otherwise to promote the sale, use or other dealings
in this Software without prior written authorization from The Open Group.

*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <X11/Xauth.h>
#include <X11/Xos.h>
#include <stdlib.h>
#include <limits.h>             /* PATH_MAX */

/* PATH_MAX is not necessarily defined. However, the specification of
 * XauFileName requires us to use statically allocated space for the
 * filename string. Therefore we need some kind of estimate for a
 * maximum path length.
 */
#ifndef PATH_MAX
#ifdef MAXPATHLEN
#define PATH_MAX MAXPATHLEN
#else /* MAXPATHLEN */
#define PATH_MAX 1024
#endif /* MAXPATHLEN */
#endif /* PATH_MAX */

char *
XauFileName (void)
{
    const char *slashDotXauthority = "/.Xauthority";
    char    *name;
    static char	buf[PATH_MAX];
#ifdef WIN32
    char    dir[128];
#endif
    int	    size;

    if ((name = getenv ("XAUTHORITY")))
	return name;
    /* This function assumes that the HOME environment variable
     * doesn't change between multiple threads. If it does change, the
     * returned string may not contain a valid file name. */
    name = getenv ("HOME");
    if (!name) {
#ifdef WIN32
	(void) strcpy (dir, "/users/");
	if ((name = getenv("USERNAME"))) {
	    (void) strcat (dir, name);
	    name = dir;
	}
	if (!name)
#endif
	return NULL;
    }
    /* Length of home directory location. */
    size = strlen (name);
    /* Check whether "/home/user" + "/.Xauthority" + "\0" fits into
     * "buf". */
    if (size + strlen (slashDotXauthority) + 1 > sizeof(buf))
        return NULL;
    /* Construct "/home/user/.Xauthority". Avoid writing null
     * character when the first part of the string is copied. That
     * could temporarily split the contents of "buf" and cause a
     * problem with multiple threads. We are assuming here that the
     * contents of "name" stay the same if this function is called
     * simultaneously from multiple threads.
     */
    strncpy (buf, name, size);
    strcpy (buf + size, slashDotXauthority + ((size <= 1) ? 1 : 0));

    return buf;
}
