<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<xsl:variable name="PARAMS" select="'Params'"/>
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>

<xsl:include href="errors.xsl"/>
<xsl:include href="news_object.xsl"/>
<xsl:include href="attachment.xsl"/>


<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response">

    <xsl:element name="{$RESPONSE}">
        <xsl:attribute name="class">news</xsl:attribute>
        <xsl:attribute name="function">getListNews</xsl:attribute>
        <xsl:element name="{$PARAMS}">

            <xsl:element name="{$ARRAY}">
                <xsl:variable name="type" select="/data/Request/Params/string[@name='newsType']"/>

                <xsl:variable name="quantity" select="count(items/item[type=$type])"/>

                <xsl:attribute name="name">newsList</xsl:attribute>
                <xsl:attribute name="page">
                        <xsl:value-of select="/data/Request/Params/number[@name='page']"/> 
                </xsl:attribute>

                <xsl:attribute name="pageSize">
                        <xsl:value-of select="/data/Request/Params/number[@name='pageSize']"/> 
                </xsl:attribute>

                <xsl:attribute name="newsType">
                        <xsl:value-of select="$type"/>
                </xsl:attribute>

                <xsl:attribute name="quantity">
                        <xsl:value-of select="number($quantity)"/>
                </xsl:attribute>

                <xsl:for-each select="items/item">

                    <xsl:variable name="authorId" select="source_id"/>
                    <xsl:variable name="created" select="date"/>
                    <xsl:variable name="text" select="text"/>

<!--type=photo-->
                    <xsl:if test="type='photo'">
                        <xsl:for-each select="photos/photo">
                            <xsl:element name="{$STRUCT}">
                                <xsl:attribute name="name">news</xsl:attribute>

                                <xsl:element name="{$STRING}">
                                   <xsl:attribute name="name">authorId</xsl:attribute>
                                    <xsl:text>vk</xsl:text>
                                   <xsl:value-of select="$authorId"/>
                                </xsl:element>

                                <xsl:if test="$authorId and $authorId != '0'">
                                  <xsl:element name="{$STRING}">
                                     <xsl:attribute name="name">authorName</xsl:attribute>
                                      <xsl:choose>
                                        <xsl:when test="contains($authorId,'-')">
                                            <xsl:value-of select="//groups/group[gid=substring-after($authorId,'-')]/name"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="//profiles/user[uid=$authorId]/first_name"/>
                                            <xsl:text> </xsl:text>
                                            <xsl:value-of select="//profiles/user[uid=$authorId]/last_name"/>
                                        </xsl:otherwise>    
                                      </xsl:choose>
                                  </xsl:element>
                                </xsl:if>

                                <xsl:element name="{$NUMBER}">
                                    <xsl:attribute name="name">created</xsl:attribute>
                                    <xsl:value-of select="$created"/>
                                </xsl:element>

                                <xsl:apply-templates select="."/>

                            </xsl:element>
                        </xsl:for-each>
                    </xsl:if>
<!--type=message-->
                    <xsl:if test="type='post'">
                            <xsl:element name="{$STRUCT}">
                                <xsl:attribute name="name">news</xsl:attribute>

                                <xsl:element name="{$STRING}">
                                   <xsl:attribute name="name">authorId</xsl:attribute>
                                    <xsl:text>vk</xsl:text>
                                   <xsl:value-of select="$authorId"/>
                                </xsl:element>

                                <xsl:if test="$authorId and $authorId != '0'">
                                  <xsl:element name="{$STRING}">
                                     <xsl:attribute name="name">authorName</xsl:attribute>
                                      <xsl:choose>
                                        <xsl:when test="contains($authorId,'-')">
                                            <xsl:value-of select="//groups/group[gid=substring-after($authorId,'-')]/name"/>
                                        </xsl:when>
                                        <xsl:otherwise>
                                            <xsl:value-of select="//profiles/user[uid=$authorId]/first_name"/>
                                            <xsl:text> </xsl:text>
                                            <xsl:value-of select="//profiles/user[uid=$authorId]/last_name"/>
                                        </xsl:otherwise>    
                                      </xsl:choose>
                                  </xsl:element>
                                </xsl:if>

                                <xsl:element name="{$NUMBER}">
                                    <xsl:attribute name="name">created</xsl:attribute>
                                    <xsl:value-of select="$created"/>
                                </xsl:element>

                                <xsl:element name="{$STRING}">
                                    <xsl:attribute name="name">text</xsl:attribute>
                                    <xsl:value-of select="$text"/>
                                </xsl:element>

                                <xsl:apply-templates select="attachment"/>

                            </xsl:element>
                    </xsl:if>

                </xsl:for-each>
            </xsl:element> 

        </xsl:element> 
    </xsl:element> 
</xsl:template>

</xsl:stylesheet>
