<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="text"/>
<xsl:param name="MID"/>  
<xsl:param name="SID"/>  
<xsl:param name="SECRET"/>

<xsl:variable name="RESPONSE" select="'Response'"/>
<!--xsl:variable name="PARAMS" select="'Params'"/-->
<xsl:variable name="STRING" select="'string'"/>
<xsl:variable name="NUMBER" select="'number'"/>
<xsl:variable name="STRUCT" select="'struct'"/>
<xsl:variable name="ARRAY" select="'array'"/>
<xsl:variable name="IMG" select="'img'"/>


<xsl:template match="/">
 <xsl:apply-templates select="/data/response"/>
 <xsl:apply-templates select="/data/error"/>
 <xsl:apply-templates select="/data/info"/>
</xsl:template>

<xsl:template match="response|error|info">

                    <xsl:element name="{$STRUCT}">
                        <xsl:attribute name="name">album</xsl:attribute>
                        <xsl:attribute name="id">
                        <xsl:value-of select="/data/Request/Params/string[@name = 'albumId']"/>
                        </xsl:attribute>
        
                        <xsl:element name="{$STRING}">
                           <xsl:attribute name="name">title</xsl:attribute>
                           <xsl:value-of select="/data/Request/Params/string[@name = 'title']"/>
                        </xsl:element>

                        <xsl:element name="{$STRING}">
                            <xsl:attribute name="name">description</xsl:attribute>
                            <xsl:value-of select="/data/Request/Params/string[@name = 'description']"/>
                        </xsl:element>

                        <xsl:if test="photos/item[1]">
                            <xsl:element name="{$STRING}">
                                <xsl:attribute name="name">thumbId</xsl:attribute>
                                  <xsl:text>vk</xsl:text>
                                  <xsl:value-of select="photos/item[1]/pid"/>
                            </xsl:element>

                            <xsl:element name="{$IMG}">
                                <xsl:attribute name="name">Img</xsl:attribute>
                                    <xsl:value-of select="photos/item[1]/src"/>
                            </xsl:element>
                        </xsl:if>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">created</xsl:attribute>
                            <xsl:value-of select="/data/Request/Params/number[@name = 'created']"/>
                        </xsl:element>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">updated</xsl:attribute>
                            <xsl:value-of select="/data/Request/Params/number[@name = 'updated']"/>
                        </xsl:element>

                        <xsl:element name="{$NUMBER}">
                            <xsl:attribute name="name">size</xsl:attribute>
                            <xsl:value-of select="/data/Request/Params/string[@name = 'page']"/>
                        </xsl:element>
                    </xsl:element>
</xsl:template>
</xsl:stylesheet>
