/*
 * profile.h - methods and structs for work with profile data
 * This file is part of MySocials driver library
 *
 * Copyright (C) 2011 - MySocials team
 *
 * libvkontakte library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * libvkontakte library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with libvkontakte library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#ifndef _PROFILE_H_
#define _PROFILE_H_

#include <QObject>
#include <QLibrary>
#include <QDebug>
#include <QDomDocument>
#include <QDomElement>
/*
 * Class contains all required data for profile. Data load from program and store during work time.
 */
class Profile;

/*! \typedef ProfileList
 list of active profiles
 \sa QRefreshList
*/
typedef QList<Profile*> ProfileList;


class  Profile : public QObject
{
    Q_OBJECT

public:
    /**
      \brief Default constructor.

      \param parent Pointer to parent object.
      */
    Profile(QString id);

    /**
      \brief Destructor.
      */
    ~Profile();

    void addToList();
    static Profile* getProfileById(QString id);
    bool isAuthorised();
    bool update();
    QString id;                
    QString remixmid;              
    QString remixsid;        
    QString secret;
private:
    static ProfileList profileList;
};



#endif
