/*
 * vk_parser.c -  parser for MySocials driver
 * This file is part of MSA program
 *
 * Copyright (C) 2009, 2010, 2011 - MySocials team
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
#include "parser.h"

#ifdef NOT_USE_DEFAULT_TEXT_PARSER
int text_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    char* tmp = NULL;
    char* amp = NULL;
    short fix;
    int k = 0;
    
    MSA_UNUSED(inner_req);
    MSA_UNUSED(cp);
    MSA_UNUSED(data_size);

    tmp = data;
    while((tmp = strstr(tmp, "<br>")) != NULL)
    {
        for(k = 0; k < 3; k++)
            *(tmp++) = ' ';
        *(tmp) = '\n';
    }

    tmp = data;
    while((tmp = strstr(tmp, "&amp;lt;br&amp;gt;")) != NULL)
    {
        for(k = 0; k < 17; k++)
            *(tmp++) = ' ';
        *(tmp) = '\n';
    }

    tmp = data;
    fix = 1;
    while((tmp = strstr(tmp, "&amp;quot;")) != NULL)
    {
        if (fix) { // left quot
            for(k = 0; k < 4; k++)
                *(tmp++) = ' ';
            *(tmp) = '&';
        } else { // right quot
            *(++tmp)='q';
            *(++tmp)='u';
            *(++tmp)='o';
            *(++tmp)='t';
            *(++tmp)=';';
            for(k = 0; k < 4; k++)
                *(++tmp) = ' ';
        }
        fix = 1-fix;
    }

    tmp = data;
    while((tmp = strstr(tmp, "&amp;#")) != NULL)
    {
        fix = 0;
        amp=tmp;
        tmp+=6;
        if (*tmp == 'x') {
            while ((*(++tmp) != '\0') && ( g_ascii_isdigit(*tmp) || ((*tmp >= 'a') && (*tmp <= 'f')) || ((*tmp >= 'A') && (*tmp <= 'F'))));
            if (*tmp == ';') // NOTE: skipped expressions &#x;
                fix = 1;
        } else if (g_ascii_isdigit(*tmp)) {
            while (g_ascii_isdigit(*(++tmp)));
            if (*tmp == ';')
                fix = 1;
        }
        if (fix) {
            for(k = 0; k < 4; k++)
                *(amp++) = ' ';
            *(amp) = '&';
        }
    }

    tmp = NULL;

/*
FIXME
replace & to &amp; in url
*/
/*
    tmp = data;
    while((tmp = strstr(tmp, "http")) != NULL)
    {
        while(*tmp != '<' && *tmp != '\0'){
            if(*tmp == '&' && !g_str_has_prefix(tmp, "&amp;") 
                           && !g_str_has_prefix(tmp, "&lt;")
                           && !g_str_has_prefix(tmp, "&gt;")
                           && !g_str_has_prefix(tmp, "&apos;")
                           && !g_str_has_prefix(tmp, "&quot;")
                           && !g_str_has_prefix(tmp, "&#x")){
                *tmp = ' ';
            }
            tmp++;
        }
    }
*/

    tmp = data;
    while((tmp = strchr(tmp, '&')) != NULL)
    {
        amp = tmp++;
        fix = 0;
        if (g_ascii_isalpha(*tmp)) {
            while ((*(++tmp) != '\0') && g_ascii_isalpha(*tmp));
            if (*tmp != ';')
                fix = 1;
        } else if (*tmp == '#') {
            if (*(++tmp) == 'x') {
                while ((*(++tmp) != '\0') && ( g_ascii_isdigit(*tmp) || ((*tmp >= 'a') && (*tmp <= 'f')) || ((*tmp >= 'A') && (*tmp <= 'F'))));
                if (*tmp != ';') // NOTE: skipped expressions &#x;
                    fix = 1;
            } else if (g_ascii_isdigit(*tmp)) {
                while (g_ascii_isdigit(*(++tmp)));
                if (*tmp != ';')
                    fix = 1;
            } else
                fix = 1;
        } else {
            fix = 1;
        }

        if (fix)
            *amp = ' ';
    }

    *response = g_strdup(data);
    return 0;
}
#endif


/*
 * Parse back url
 *
 * @param inner_req - inner request
 * @param cp - profile
 * @param data - redirect url from server
 * @param data_size - size of url
 * @param response - response in xml
 * @return 0 if login success, 1 if login failure
 */
#ifdef NOT_USE_DEFAULT_WEBAUTH_PARSER
int webauth_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    gchar* tmp = NULL;

    MSA_UNUSED(inner_req);
    MSA_UNUSED(cp);
    MSA_UNUSED(data_size);

    if(data != NULL){
        if (g_strrstr(data, "login_success") != NULL)
        {
            tmp = g_strrstr(data, "session=");
            if (tmp != NULL){
                tmp = tmp + 8;
                json_parser(NULL, NULL, tmp, 0, response);
                return 0;
            }
        }
        if(g_strcmp0(data, "closed") == 0 || g_strrstr(data, "login_failure") != NULL)
            *response = g_strdup(MSG_AUTH_CANCEL);
            return 1;
    } 
    *response = g_strdup(MSG_AUTH_ERROR);
    return 1;
}
#endif

#ifdef NOT_USE_DEFAULT_WEBCAPTCHA_PARSER
int webcaptcha_parser(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    if(data != NULL){
        if(g_strcmp0(data, "closed") == 0){
            *response = g_strdup(MSG_CAPT_ERROR);
            return 1;
        } else {
            *response = g_strdup_printf("<response>%s</response>",data);
            return 0;
        }
    } 
    *response = g_strdup(MSG_CAPT_ERROR);
    return 1;

}
#endif

#ifdef NOT_USE_DEFAULT_PROCESS_URL
void process_url(xmlDocPtr inner_req, const struct ProfileData *cp, gchar* data, int data_size, gchar **response)
{
    xmlNodePtr sig_node = NULL;
    gchar *sig = NULL, *md5_sig = NULL;

    MSA_UNUSED(cp);
    MSA_UNUSED(data_size);
 
    sig_node = xpath_get_node("//InnerRequest/sig", inner_req);
    if (sig_node != NULL){
        sig = (gchar*)xmlNodeGetContent(sig_node);
        md5_sig = g_compute_checksum_for_string(G_CHECKSUM_MD5, sig, strlen(sig));
        g_free(sig);
        *response = g_strconcat(data, "sig=", md5_sig, NULL);
        g_free(md5_sig);
    } else                 
        *response = g_strdup(data);
}
#endif
